<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<title>ContratoDatosBasicos</title>
	<link href="css/style.css" rel="stylesheet" media="screen" />
</head>
<body>
	<div class="container">
		<div class="margin-bottom-1em overflow-hidden">
			<div id="read" class="btn btn-primary pull-right">
				<span class="glyphicon glyphicon-list"></span> Listar ContratoDatosBasicos
			</div>
			<div id="create" class="btn btn-primary pull-right">
				<span class="glyphicon glyphicon-plus"></span> Crear ContratoDatosBasicos
			</div>
			<div id="loader-image" class="loading-gif"></div>
		</div>
		<div class="page-header">
			<h1 id="page-title"></h1>
		</div>
		<br>
		<div id="message_alerta" style="display:none"></div>
		<div id="page-content"></div>
	</div>
	<link rel="stylesheet" type="text/css" href="css/jquery.dataTables.css">
	<script type="text/javascript" language="javascript" src= "js/js/jquery.dataTables.js"></script>	
	<script type="text/javascript">
		$(document).ready(function(){
			$("#read").hide();
			$("#create").hide();
			Listar();
			$("#create").click(function(){create();});
			$("#loader-image").show();
			$("#read").click(function(){read();});
			$(document).on("submit", "#create-form", function() {guardarCreate($(this).serialize());return false;});
			$(document).on("click", ".edit-btn", function(){edit($(this).closest("td").find(".id").text());}); 
			$(document).on("click", ".delete-btn", function(){ 
				if(confirm("Esta Seguro que desea Eliminar el Registro?")){
					eliminar($(this).closest("td").find(".id").text());
				}
			});
		});
		function changePageTitle(page_title)
		{
			$("#page-title").text(page_title);
			document.title=page_title;
		}
		function Listar()
		{
			$("#create").show();
			changePageTitle("Listar ContratoDatosBasicos");
			$("#message_alerta").css("display","none");
			$("#page-content").fadeOut("slow", function()
			{
				tabla ="<table class='table table-striped' id='dt_lista_usuarios'>";
				tabla=tabla +"<thead><tr>";
				tabla=tabla +"<th>N SOC</th>";
				tabla=tabla +"<th>Licitacion</th>";
				tabla=tabla +"<th>Clase</th>";
				tabla=tabla +"<th>Numero Contrato</th>";
				tabla=tabla +"<th>Contratista</th>";
				tabla=tabla +"<th>Teléfono Contratista</th>";
				tabla=tabla +"<th>Direccion Contratista</th>";
				tabla=tabla +"<th>Numero Identificación</th>";
				tabla=tabla +"<th>Correo Electronico</th>";
				tabla=tabla +"<th>Representante Legal</th>";
				tabla=tabla +"<th>Objeto</th>";
				tabla=tabla +"<th>Estado</th>";
				tabla=tabla +"<th>rubro</th>";
				tabla=tabla +"<th>Fecha Inicio Del Contrato</th>";
				tabla=tabla +"<th>Fecha Terminacion</th>";
				tabla=tabla +"<th>Interventoria</th>";
				tabla=tabla +"<th>Supervisor</th>";
				tabla=tabla +"<th>Valor Contrato Inicial</th>";
				tabla=tabla +"<th>Valor Total Contrato</th>";
				tabla=tabla +"<th>Porcentaje Ejecutado En Actas</th>";
				tabla=tabla +"<th>Fecha Del Contrato</th>";
				tabla=tabla +"<th>Cuenta Conjunta</th>";
				tabla=tabla +"<th>Pólizas No</th>";
				tabla=tabla +"<th>Aseguradora</th>";
				tabla=tabla +"<th>Fecha Aprobación Póliza Inicial</th>";
				tabla=tabla +"<th>Fecha Radicacion De Contrato A Construcciones</th>";
				tabla=tabla +"<th>Numero CDP</th>";
				tabla=tabla +"<th>Fecha CDP</th>";
				tabla=tabla +"<th>Numero RP</th>";
				tabla=tabla +"<th>Fecha RP</th>";
				tabla=tabla +"<th data-orderable='false' style='text-align:center;'></th>";
				tabla=tabla +"<th data-orderable='false' style='text-align:center;'></th>";
				tabla=tabla +"</tr></thead>";
				tabla=tabla +"<tbody></tbody>";
				tabla=tabla +"</table>";
				$("#loader-image").hide();
				$("#page-content").fadeIn("slow");
				$("#page-content").empty();
				$("#page-content").append(tabla);
				$("#dt_lista_usuarios").DataTable(
				{
					"language":
					{
						"emptyTable":"No hay información disponible",
						"info":"Listado _START_ a _END_ de _TOTAL_ Registros",
						"infoEmpty":"Listado 0 a 0 de 0 Registros",
						"infoFiltered":"(filtrado de _MAX_ registros)",
						"infoPostFix":"",
						"thousands":",",
						"lengthMenu":"Mostrar _MENU_ Registros",
						"loadingRecords": "Cargando...",
						"processing":     "Procesando...",
						"search":         "Buscar:",
						"zeroRecords":    "No se encontraron registros",
						"paginate": {
							"first":      "Primera",
							"last":       "Ultima",
							"next":       "Siguiente",
							"previous":   "Anterior"
						}
					}
				});
				var tabla=$("#dt_lista_usuarios").DataTable();
				$.post("ContratoDatosBasicos/Actualizar.php",{accion:"4"},
					function(data)
					{
						if(data!="0")
						{
							for(var i=0;i<data.length;i++)
							{
								tabla.row.add( 
								[
									data[i].numeroSOC,
									data[i].licitacion,
									data[i].clase,
									data[i].numeroContrato,
									data[i].contratista,
									data[i].telefonoC,
									data[i].direccionC,
									data[i].numeroIdentificacionC,
									data[i].correoElectronicoC,
									data[i].representanteLegal,
									data[i].objeto,
									data[i].estado,
									data[i].rubro,
									data[i].fechaInicio,
									data[i].fechaTerminacion,
									data[i].interventoria,
									data[i].supervisor,
									data[i].valorContratoInicial,
									data[i].valorTotalContrato,
									data[i].porcentajeEjecutado,
									data[i].fechaContrato,
									data[i].cuentaConjunta,
									data[i].numeroPoliza,
									data[i].aseguradora,
									data[i].fechaAprobacionPoliza,
									data[i].fechaRadicacion,
									data[i].numeroCDP,
									data[i].fechaCDP,
									data[i].numeroRP,
									data[i].fechaRP,
									"<div class='id' style='display:none;' >"+data[i].idContrato+"</div><button class='btn btn-info edit-btn btn-xs' ><span class='glyphicon glyphicon-pencil'></span> Edit</button>",
									"<div class='id' style='display:none;' >"+data[i].idContrato+"</div><button class='btn btn-danger delete-btn btn-xs'><span class='glyphicon glyphicon-remove'></span> Delete</button>",
								]).draw(false);
							}
						}
						else
						{
							if (data=="0")
							{
								message(3,"No se encontraron Registros.");
							}
							else
							{
								message(4,data);
							}
						}
					},"json");
			});
		}
		function create()
		{
			changePageTitle("Crear ContratoDatosBasicos");
			$("#loader-image").show();
			$("#create").hide();
			$("#read").show();
			$("#page-content").fadeOut("slow", function()
			{
				$("#page-content").load("ContratoDatosBasicos/create_form.php", function()
				{
					$("#loader-image").hide();
					$("#page-content").fadeIn("slow");
					$("#message_alerta").css("display","none");
				});
			});
		}
		function read()
		{
			$("#loader-image").show();
			$("#create").show();
			$(".modulo").show();
			$("#read").hide();
			Listar();
		}
		function edit(id)
		{
			changePageTitle("Actualizar ContratoDatosBasicos");
			$("#loader-image").show();
			$("#create").hide();
			$("#read").show();
			$("#message_alerta").css("display","none");
			$("#page-content").fadeOut("slow", function()
			{
				$("#page-content").load("ContratoDatosBasicos/create_form.php", function()
				{
					$.post("ContratoDatosBasicos/Actualizar.php",{id:id,accion:"3"},
						function(data)
						{
							if(data!="0")
							{
								$("#id").val(data.idContrato);
								$("#numeroSOC").val(data.numeroSOC);
								$("#licitacion").val(data.licitacion);
								$("#clase").val(data.clase);
								$("#numeroContrato").val(data.numeroContrato);
								$("#contratista").val(data.contratista);
								$("#telefonoC").val(data.telefonoC);
								$("#direccionC").val(data.direccionC);
								$("#numeroIdentificacionC").val(data.numeroIdentificacionC);
								$("#correoElectronicoC").val(data.correoElectronicoC);
								$("#representanteLegal").val(data.representanteLegal);
								$("#objeto").val(data.objeto);
								$("#estado").val(data.estado);
								$("#rubro").val(data.rubro);
								$("#fechaInicio").val(data.fechaInicio);
								$("#fechaTerminacion").val(data.fechaTerminacion);
								$("#interventoria").val(data.interventoria);
								$("#supervisor").val(data.supervisor);
								$("#valorContratoInicial").val(data.valorContratoInicial);
								$("#valorTotalContrato").val(data.valorTotalContrato);
								$("#porcentajeEjecutado").val(data.porcentajeEjecutado);
								$("#fechaContrato").val(data.fechaContrato);
								$("#cuentaConjunta").val(data.cuentaConjunta);
								$("#numeroPoliza").val(data.numeroPoliza);
								$("#aseguradora").val(data.aseguradora);
								$("#fechaAprobacionPoliza").val(data.fechaAprobacionPoliza);
								$("#fechaRadicacion").val(data.fechaRadicacion);
								$("#numeroCDP").val(data.numeroCDP);
								$("#fechaCDP").val(data.fechaCDP);
								$("#numeroRP").val(data.numeroRP);
								$("#fechaRP").val(data.fechaRP);
							}
							else
							{
								if (data=="0")
								{
									message(3,"No se encontraron Registros.");
								}
								else
								{
									message(4,data);
								}
							}
						},"json");
						$("#loader-image").hide();
						$("#page-content").fadeIn("slow");
				});
			});
		}
		function guardarCreate(doc)
		{
			$("#loader-image").show();
			$.post("ContratoDatosBasicos/Actualizar.php",doc,function(data)
			{
				$("#create").show();
				$("#read").hide();
				Listar();
				if(data==1)
				{
					message(1,"Registro Agregado Correctamente.");
				}
				else if(data==3)
				{
					message(1,"Registro Actualizado Correctamente.")
				}
				else if(data==2)
				{
					message(4,"No se puede guardar el registro.")
				}
				else
				{
					message(4,data);
				}
			});
		}
		function eliminar(id)
		{
			$.post("ContratoDatosBasicos/Actualizar.php", { id:id,accion:"2"},function(data)
			{
				$("#loader-image").show();
				Listar();
				if(data==1)
				{
					message(3,"Registro Eliminado Correctamente");
				}
				else if(data==2)
				{
					message(4,"Error al Eliminar el Registro");
				}
				else
				{
					message(4,data);
				}
			});
		}
		function message(tipo,mensaje)
		{
			switch (tipo)
			{
				case(1):
					alerta='<div id="Message" class="alert alert-success alert-dismissable"><button type="button" class="close" data-dismiss="alert">&times;</button>'+mensaje+'</div>';
					break;
				case(2):
					alerta='<div id="Message" class="alert alert-info alert-dismissable"><button type="button" class="close" data-dismiss="alert">&times;</button>'+mensaje+'</div>';
					break;
				case(3):
					alerta='<div id="Message" class="alert alert-warning alert-dismissable"><button type="button" class="close" data-dismiss="alert">&times;</button>'+mensaje+'</div>';
					break;
				case(4):
					alerta='<div id="Message" class="alert alert-warning alert-dismissable"><button type="button" class="close" data-dismiss="alert">&times;</button>'+mensaje+'</div>';
					break;
			}
			$("#message_alerta").html(alerta);
			$("#message_alerta").fadeIn("slow");
				setTimeout(function(){
					$("#message_alerta").fadeOut("slow");
				},5000);
		}
	</script>
</body>
</html>
