<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<title>Proyecto</title>
	<link href="css/style.css" rel="stylesheet" media="screen" />
</head>
<body>
	<div class="container">
		<div class="margin-bottom-1em overflow-hidden">
			<div id="read" class="btn btn-primary pull-right">
				<span class="glyphicon glyphicon-list"></span> Listar Proyecto
			</div>
			<div id="create" class="btn btn-primary pull-right">
				<span class="glyphicon glyphicon-plus"></span> Crear Proyecto
			</div>
			<div id="loader-image" class="loading-gif"></div>
		</div>
		<div class="page-header">
			<h1 id="page-title"></h1>
		</div>
		<br>
		<div id="message_alerta" style="display:none"></div>
		<div id="page-content"></div>
	</div>
	<link rel="stylesheet" type="text/css" href="css/jquery.dataTables.css">
	<script type="text/javascript" language="javascript" src="js/jquery.dataTables.js"></script>
	<script type="text/javascript">
		$(document).ready(function(){
			$("#read").hide();
			$("#create").hide();
			Listar();
			$("#create").click(function(){create();});
			$("#loader-image").show();
			$("#read").click(function(){read();});
			$(document).on("submit", "#create-form", function() {
				var form = new FormData($("#create-form")[0]);
				$.ajax({
						url: "Proyecto/Actualizar.php",
						method: "POST",
						dataType: 'json',
						data: form,
						processData: false,
						contentType: false,
						success: function(data){
							
							$("#create").show();
							$("#read").hide();
							Listar();
							if(data==1)
							{
								message(1,"Registro Agregado Correctamente.");
							}
							else if(data==3)
							{
								message(1,"Registro Actualizado Correctamente.")
							}
							else if(data==2)
							{
								message(4,"No se puede guardar el registro.")
							}
							else
							{
								message(4,data);
							}
						},
						error: function(er){}
				});
				return false;
			});
			$(document).on("click", ".edit-btn", function(){edit($(this).closest("td").find(".id").text());}); 
			$(document).on("click", ".delete-btn", function(){ 
				if(confirm("Esta Seguro que desea Eliminar el Registro?")){
					eliminar($(this).closest("td").find(".id").text());
				}
			});
		});
		function changePageTitle(page_title)
		{
			$("#page-title").text(page_title);
			document.title=page_title;
		}
		function Listar()
		{
			$("#create").show();
			changePageTitle("Listar Proyecto");
			$("#message_alerta").css("display","none");
			$("#page-content").fadeOut("slow", function()
			{
				tabla ="<table class='table table-striped' id='dt_lista_usuarios'>";
				tabla=tabla +"<thead><tr>";
				tabla=tabla +"<th>Nombre Proyecto</th>";
				tabla=tabla +"<th>Direccion</th>";
				//tabla=tabla +"<th>Año Entrega</th>";
				tabla=tabla +"<th>Estado</th>";
				tabla=tabla +"<th>Avance</th>";
				//tabla=tabla +"<th>Área Intervenir</th>";
				/*tabla=tabla +"<th>Aulas Primera Infancia 1 o 0</th>";
				tabla=tabla +"<th>Aulas Primera Infancia</th>";
				tabla=tabla +"<th>Aulas Primaria</th>";
				tabla=tabla +"<th>Aulas Secundaria</th>";
				tabla=tabla +"<th>Aulas Media</th>";
				tabla=tabla +"<th>Capacidad Alumnos</th>";
				tabla=tabla +"<th>Valor Obra  Interventoria</th>";
				tabla=tabla +"<th>Jardín Primera Infancia</th>";
				tabla=tabla +"<th>Supervisor</th>";
				tabla=tabla +"<th>Imagen</th>";
				tabla=tabla +"<th>Reportados en Ejecución</th>";
				tabla=tabla +"<th>Estado BH</th>";
				tabla=tabla +"<th>Avance BH</th>";
				tabla=tabla +"<th>Id Sede</th>";
				tabla=tabla +"<th>Id Meta</th>";
				tabla=tabla +"<th>Id Financiacion</th>";
				tabla=tabla +"<th>Id Categoria</th>";
				tabla=tabla +"<th>Id Estado</th>";*/
				tabla=tabla +"<th>Reporte</th>";
				tabla=tabla +"<th data-orderable='false' style='text-align:center;'></th>";
				tabla=tabla +"<th data-orderable='false' style='text-align:center;'></th>";
				tabla=tabla +"</tr></thead>";
				tabla=tabla +"<tbody></tbody>";
				tabla=tabla +"</table>";
				$("#loader-image").hide();
				$("#page-content").fadeIn("slow");
				$("#page-content").empty();
				$("#page-content").append(tabla);
				$("#dt_lista_usuarios").DataTable(
				{
					"language":
					{
						"emptyTable":"No hay información disponible",
						"info":"Listado _START_ a _END_ de _TOTAL_ Registros",
						"infoEmpty":"Listado 0 a 0 de 0 Registros",
						"infoFiltered":"(filtrado de _MAX_ registros)",
						"infoPostFix":"",
						"thousands":",",
						"lengthMenu":"Mostrar _MENU_ Registros",
						"loadingRecords": "Cargando...",
						"processing":     "Procesando...",
						"search":         "Buscar:",
						"zeroRecords":    "No se encontraron registros",
						"paginate": {
							"first":      "Primera",
							"last":       "Ultima",
							"next":       "Siguiente",
							"previous":   "Anterior"
						}
					}
				});
				var tabla=$("#dt_lista_usuarios").DataTable();
				$.post("Proyecto/Actualizar.php",{accion:"4"},
					function(data)
					{
						if(data!="0")
						{
							for(var i=0;i<data.length;i++)
							{
								tabla.row.add( 
								[
									data[i].nombreProyecto,
									data[i].direccion,
									//data[i].anoEntrega,
									data[i].idEstado,
									data[i].avanceEtapa,
									/*data[i].areaIntervenir,
									data[i].aulasPIA,
									data[i].aulasPIB,
									data[i].aulasP,
									data[i].aulasS,
									data[i].aulasM,
									data[i].capacidadAlumnos,
									data[i].valorOI,
									data[i].jardinPI,
									data[i].supervisor,
									data[i].imagen,
									data[i].reportadosEje,
									data[i].estadoBH,
									data[i].avanceBH,
									data[i].idSede,
									data[i].idMeta,
									data[i].idFinanciacion,
									data[i].idCategoria,
									data[i].idEstado,*/
									"<form method='post' action='oferta/AgregarTabla.php' target='_blank'><input type='hidden' name='id' value='"+data[i].idSede+"' /><input type='image' src='Img/ver.png' /></form>",
									"<div class='id' style='display:none;' >"+data[i].idProyecto+"</div><button class='btn btn-info edit-btn btn-xs' ><span class='glyphicon glyphicon-pencil'></span> Edit</button>",
									"<div class='id' style='display:none;' >"+data[i].idProyecto+"</div><button class='btn btn-danger delete-btn btn-xs'><span class='glyphicon glyphicon-remove'></span> Delete</button>",
								]).draw(false);
							}
						}
						else
						{
							if (data=="0")
							{
								message(3,"No se encontraron Registros.");
							}
							else
							{
								message(4,data);
							}
						}
					},"json");
			});
		}
		function create()
		{
			changePageTitle("Crear Proyecto");
			$("#loader-image").show();
			$("#create").hide();
			$("#read").show();
			$("#page-content").fadeOut("slow", function()
			{
				$("#page-content").load("Proyecto/create_form.php", function()
				{
					$("#loader-image").hide();
					$("#page-content").fadeIn("slow");
					$("#message_alerta").css("display","none");
					cargarComboPorcentaje();
					cargarSedes();
					cargarMetas();
					cargarFinanciacion();
					cargarCategorias();
					cargarEstados();
					cargarEstadosBH();
					cargarEtapa();
				});
			});
		}
		function read()
		{
			$("#loader-image").show();
			$("#create").show();
			$(".modulo").show();
			$("#read").hide();
			Listar();
		}
		function edit(id)
		{
			changePageTitle("Update Proyecto");
			$("#loader-image").show();
			$("#create").hide();
			$("#read").show();
			$("#message_alerta").css("display","none");
			$("#page-content").fadeOut("slow", function()
			{
				$("#page-content").load("Proyecto/create_form.php", function()
				{
					cargarComboPorcentaje();
					$.post("Proyecto/Actualizar.php",{id:id,accion:"3"},
						function(data)
						{
							if(data!="0")
							{
								$("#id").val(data.idProyecto);
								$("#nombreProyecto").val(data.nombreProyecto);
								$("#direccion").val(data.direccion);
								$("#anoEntrega").val(data.anoEntrega);
								$("#avanceEtapa").val(data.avanceEtapa);
								$("#areaIntervenir").val(data.areaIntervenir);
								$("#aulasPIA").val(data.aulasPIA);
								$("#aulasPIB").val(data.aulasPIB);
								$("#aulasP").val(data.aulasP);
								$("#aulasS").val(data.aulasS);
								$("#aulasM").val(data.aulasM);
								$("#capacidadAlumnos").val(data.capacidadAlumnos);
								$("#valorOI").val(data.valorOI);
								$("#jardinPI").val(data.jardinPI);
								$("#supervisor").val(data.supervisor);
								$("#imagen").val(data.imagen);
								$("#reportadosEje").val(data.reportadosEje);
								$("#avanceBH").val(data.avanceBH);								
								$("#update").val('U');//Update
								$('.observacion').hide();
								cargarSedes(data.idSede);	
								cargarMetas(data.idMeta);
								cargarFinanciacion(data.idFinanciacion);
								cargarCategorias(data.idCategoria);
								cargarEstados(data.idEstado);
								cargarEstadosBH(data.estadoBH);
								cargarEtapa(data.etapa);
							}
							else
							{
								if (data=="0")
								{
									message(3,"No se encontraron Registros.");
								}
								else
								{
									message(4,data);
								}
							}
						},"json");
						$("#loader-image").hide();
						$("#page-content").fadeIn("slow");
				});
			});
		}
		function guardarCreate(doc)
		{
			$("#loader-image").show();
			$.post("Proyecto/Actualizar.php",doc,function(data)
			{
				$("#create").show();
				$("#read").hide();
				Listar();
				if(data==1)
				{
					message(1,"Registro Agregado Correctamente.");
				}
				else if(data==3)
				{
					message(1,"Registro Actualizado Correctamente.")
				}
				else if(data==2)
				{
					message(4,"No se puede guardar el registro.")
				}
				else
				{
					message(4,data);
				}
			});
		}
		function eliminar(id)
		{
			$.post("Proyecto/Actualizar.php", { id:id,accion:"2"},function(data)
			{
				$("#loader-image").show();
				Listar();
				if(data==1)
				{
					message(3,"Registro Eliminado Correctamente");
				}
				else if(data==2)
				{
					message(4,"Error al Eliminar el Registro");
				}
				else
				{
					message(4,data);
				}
			});
		}
		function message(tipo,mensaje)
		{
			switch (tipo)
			{
				case(1):
					alerta='<div id="Message" class="alert alert-success alert-dismissable"><button type="button" class="close" data-dismiss="alert">&times;</button>'+mensaje+'</div>';
					break;
				case(2):
					alerta='<div id="Message" class="alert alert-info alert-dismissable"><button type="button" class="close" data-dismiss="alert">&times;</button>'+mensaje+'</div>';
					break;
				case(3):
					alerta='<div id="Message" class="alert alert-warning alert-dismissable"><button type="button" class="close" data-dismiss="alert">&times;</button>'+mensaje+'</div>';
					break;
				case(4):
					alerta='<div id="Message" class="alert alert-warning alert-dismissable"><button type="button" class="close" data-dismiss="alert">&times;</button>'+mensaje+'</div>';
					break;
			}
			$("#message_alerta").html(alerta);
			$("#message_alerta").fadeIn("slow");
				setTimeout(function(){
					$("#message_alerta").fadeOut("slow");
				},5000);
		}
		function cargarSedes(id)
		{
			var opciones="";
			$.post("Proyecto/Actualizar.php",{accion:"6"},
				function(data)
				{
					if(data!="0")
					{
						for(var i=0;i<data.length;i++)
						{
							opciones=opciones + '<option value='+data[i].idSede+'>'+data[i].nombre+'</option>';
						}
						$("#idSede").append(opciones);
						$("#idSede").val(id);
						
					}
					else
					{
						if (data=="0")
						{
							message(3,"No se encontraron Registros.");
						}
						else
						{
							message(4,data);
						}
					}
				},"json");
		}
		function cargarMetas(id)
		{
			var opciones="";
			$.post("Proyecto/Actualizar.php",{accion:"7"},
				function(data)
				{
					if(data!="0")
					{
						for(var i=0;i<data.length;i++)
						{
							opciones=opciones + '<option value='+data[i].idMeta+'>'+data[i].nombre+'</option>';
						}
						$("#idMeta").append(opciones);
						$("#idMeta").val(id);
						
					}
					else
					{
						if (data=="0")
						{
							message(3,"No se encontraron Registros.");
						}
						else
						{
							message(4,data);
						}
					}
				},"json");
		}
		function cargarFinanciacion(id)
		{
			var opciones="";
			$.post("Proyecto/Actualizar.php",{accion:"8"},
				function(data)
				{
					if(data!="0")
					{
						for(var i=0;i<data.length;i++)
						{
							opciones=opciones + '<option value='+data[i].idFinanciacion+'>'+data[i].nombre+'</option>';
						}
						$("#idFinanciacion").append(opciones);
						$("#idFinanciacion").val(id);
						
					}
					else
					{
						if (data=="0")
						{
							message(3,"No se encontraron Registros.");
						}
						else
						{
							message(4,data);
						}
					}
				},"json");
		}
		function cargarCategorias(id)
		{
			var opciones="";
			$.post("Proyecto/Actualizar.php",{accion:"9"},
				function(data)
				{
					if(data!="0")
					{
						for(var i=0;i<data.length;i++)
						{
							opciones=opciones + '<option value='+data[i].idCategoria+'>'+data[i].nombre+'</option>';
						}
						$("#idCategoria").append(opciones);
						$("#idCategoria").val(id);
						
					}
					else
					{
						if (data=="0")
						{
							message(3,"No se encontraron Registros.");
						}
						else
						{
							message(4,data);
						}
					}
				},"json");
		}
		function cargarEstados(id)
		{
			var opciones="";
			$.post("Proyecto/Actualizar.php",{accion:"10"},
				function(data)
				{
					if(data!="0")
					{
						for(var i=0;i<data.length;i++)
						{
							opciones=opciones + '<option value='+data[i].idEstado+'>'+data[i].nombre+'</option>';
						}
						$("#idEstado").append(opciones);
						$("#idEstado").val(id);
						
					}
					else
					{
						if (data=="0")
						{
							message(3,"No se encontraron Registros.");
						}
						else
						{
							message(4,data);
						}
					}
				},"json");
		}
		function cargarEstadosBH(id)
		{
			var opciones="";
			$.post("Proyecto/Actualizar.php",{accion:"11"},
				function(data)
				{
					if(data!="0")
					{
						for(var i=0;i<data.length;i++)
						{
							opciones=opciones + '<option value='+data[i].idEstado+'>'+data[i].nombre+'</option>';
						}
						$("#estadoBH").append(opciones);
						$("#estadoBH").val(id);
						
					}
					else
					{
						if (data=="0")
						{
							message(3,"No se encontraron Registros.");
						}
						else
						{
							message(4,data);
						}
					}
				},"json");
		}
		function cargarEtapa(id)
		{
			var opciones="";
			$.post("Proyecto/Actualizar.php",{accion:"12"},
				function(data)
				{
					if(data!="0")
					{
						for(var i=0;i<data.length;i++)
						{
							opciones=opciones + '<option value='+data[i].idEtapa+'>'+data[i].nombre+'</option>';
						}
						$("#etapa").append(opciones);					
						$("#etapa").val(id);
						
					}
					else
					{
						if (data=="0")
						{
							message(3,"No se encontraron Registros.");
						}
						else
						{
							message(4,data);
						}
					}
				},"json");
		}
		function cargarComboPorcentaje()
		{
			var opciones='';
			for (var i=0; i<=100; i++) 
			{
				opciones=opciones + '<option value='+i+'%>'+i+'%</option>';
			}
			$("#avanceBH").append(opciones);
			$("#avanceEtapa").append(opciones);
		}
	</script>
</body>
</html>
