<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<title>Sede</title>
	<link href="css/style.css" rel="stylesheet" media="screen" />
</head>
<body>
	<div class="container">
		<div class="margin-bottom-1em overflow-hidden">
			<div id="read" class="btn btn-primary pull-right">
				<span class="glyphicon glyphicon-list"></span> Listar Sede
			</div>
			<div id="create" class="btn btn-primary pull-right">
				<span class="glyphicon glyphicon-plus"></span> Crear Sede
			</div>
			<div id="loader-image" class="loading-gif"></div>
		</div>
		<div class="page-header">
			<h1 id="page-title"></h1>
		</div>
		<br>
		<div id="message_alerta" style="display:none"></div>
		<div id="page-content"></div>
	</div>
	<link rel="stylesheet" type="text/css" href="css/jquery.dataTables.css">
	<script type="text/javascript" language="javascript" src="js/jquery.dataTables.js"></script>
	<script type="text/javascript">
		$(document).ready(function(){
			$("#read").hide();
			$("#create").hide();
			Listar();
			$("#create").click(function(){create();});
			$("#loader-image").show();
			$("#read").click(function(){read();});
			$(document).on("submit", "#create-form", function() {guardarCreate($(this).serialize());return false;});
			$(document).on("click", ".edit-btn", function(){edit($(this).closest("td").find(".id").text());}); 
			$(document).on("click", ".delete-btn", function(){ 
				if(confirm("Esta Seguro que desea Eliminar el Registro?")){
					eliminar($(this).closest("td").find(".id").text());
				}
			});
		});
		function changePageTitle(page_title)
		{
			$("#page-title").text(page_title);
			document.title=page_title;
		}
		function Listar()
		{
			$("#create").show();
			changePageTitle("Listar Sede");
			$("#message_alerta").css("display","none");
			$("#page-content").fadeOut("slow", function()
			{
				tabla ="<table class='table table-striped' id='dt_lista_usuarios'>";
				tabla=tabla +"<thead><tr>";
				tabla=tabla +"<th>Establecimiento</th>";
				tabla=tabla +"<th>Localidad</th>";
				tabla=tabla +"<th>Nombre Sede Educativa</th>";
				tabla=tabla +"<th>Reporte</th>";
				tabla=tabla +"<th data-orderable='false' style='text-align:center;'></th>";
				tabla=tabla +"<th data-orderable='false' style='text-align:center;'></th>";
				tabla=tabla +"</tr></thead>";
				tabla=tabla +"<tbody></tbody>";
				tabla=tabla +"</table>";
				$("#loader-image").hide();
				$("#page-content").fadeIn("slow");
				$("#page-content").empty();
				$("#page-content").append(tabla);
				$("#dt_lista_usuarios").DataTable(
				{
					"language":
					{
						"emptyTable":"No hay información disponible",
						"info":"Listado _START_ a _END_ de _TOTAL_ Registros",
						"infoEmpty":"Listado 0 a 0 de 0 Registros",
						"infoFiltered":"(filtrado de _MAX_ registros)",
						"infoPostFix":"",
						"thousands":",",
						"lengthMenu":"Mostrar _MENU_ Registros",
						"loadingRecords": "Cargando...",
						"processing":     "Procesando...",
						"search":         "Buscar:",
						"zeroRecords":    "No se encontraron registros",
						"paginate": {
							"first":      "Primera",
							"last":       "Ultima",
							"next":       "Siguiente",
							"previous":   "Anterior"
						}
					}
				});
				var tabla=$("#dt_lista_usuarios").DataTable();
				$.post("Sede/Actualizar.php",{accion:"4"},
					function(data)
					{
						if(data!="0")
						{
							for(var i=0;i<data.length;i++)
							{
								tabla.row.add( 
								[
									data[i].Establecimiento,
									data[i].Localidad,
									data[i].nombre,
									"<form method='post' action='oferta/EditarTabla.php' target='_blank'><input type='hidden' name='id' value='"+data[i].idSede+"' /><input type='image' src='Img/ver.png' /></form>",
									"<div class='id' style='display:none;' >"+data[i].idSede+"</div><button class='btn btn-info edit-btn btn-xs' ><span class='glyphicon glyphicon-pencil'></span> Edit</button>",
									"<div class='id' style='display:none;' >"+data[i].idSede+"</div><button class='btn btn-danger delete-btn btn-xs'><span class='glyphicon glyphicon-remove'></span> Delete</button>",
								]).draw(false);
							}
						}
						else
						{
							if (data=="0")
							{
								message(3,"No se encontraron Registros.");
							}
							else
							{
								message(4,data);
							}
						}
					},"json");
			});
		}
		function create()
		{
			changePageTitle("Crear Sede");
			$("#loader-image").show();
			$("#create").hide();
			$("#read").show();
			$("#page-content").fadeOut("slow", function()
			{
				$("#page-content").load("Sede/create_form.php", function()
				{
					$("#loader-image").hide();
					$("#page-content").fadeIn("slow");
					$("#message_alerta").css("display","none");
					cargarEstablecimiento();
					cargarLocalidad();
					cargarUPZ();
				});
			});
		}
		function read()
		{
			$("#loader-image").show();
			$("#create").show();
			$(".modulo").show();
			$("#read").hide();
			Listar();
		}
		function edit(id)
		{
			changePageTitle("Actualizar Sede");
			$("#loader-image").show();
			$("#create").hide();
			$("#read").show();
			$("#message_alerta").css("display","none");
			$("#page-content").fadeOut("slow", function()
			{
				$("#page-content").load("Sede/create_form.php", function()
				{
					$.post("Sede/Actualizar.php",{id:id,accion:"3"},
						function(data)
						{
							if(data!="0")
							{
								$("#id").val(data.idSede);
								$("#nombre").val(data.nombre);
								$("#codigoDane").val(data.codigoDane);
								$("#consecutivo").val(data.consecutivo);
								$("#orden").val(data.orden);
								$("#sector").val(data.sector);
								$("#zona").val(data.zona);
								$("#direccion").val(data.direccion);
								$("#barrio").val(data.barrio);
								$("#telefono").val(data.telefono);
								$("#correoElectronico").val(data.correoElectronico);
								$("#web").val(data.web);
								$("#rector").val(data.rector);
								$("#tipoDocumentoRector").val(data.tipoDocumentoRector);
								$("#numeroDocumentoRector").val(data.numeroDocumentoRector);
								$("#cargo").val(data.cargo);
								$("#codigoPlantaFisica").val(data.codigoPlantaFisica);
								$("#concesion").val(data.concesion);
								cargarEstablecimiento(data.idEstablecimiento);
								cargarLocalidad(data.idLocalidad);
								cargarUPZ(data.idUPZ);
							}
							else
							{
								if (data=="0")
								{
									message(3,"No se encontraron Registros.");
								}
								else
								{
									message(4,data);
								}
							}
						},"json");
						$("#loader-image").hide();
						$("#page-content").fadeIn("slow");
				});
			});
		}
		function guardarCreate(doc)
		{
			$("#loader-image").show();
			$.post("Sede/Actualizar.php",doc,function(data)
			{
				$("#create").show();
				$("#read").hide();
				Listar();
				if(data==1)
				{
					message(1,"Registro Agregado Correctamente.");
				}
				else if(data==3)
				{
					message(1,"Registro Actualizado Correctamente.")
				}
				else if(data==2)
				{
					message(4,"No se puede guardar el registro.")
				}
				else
				{
					message(4,data);
				}
			});
		}
		function eliminar(id)
		{
			$.post("Sede/Actualizar.php", { id:id,accion:"2"},function(data)
			{
				$("#loader-image").show();
				Listar();
				if(data==1)
				{
					message(3,"Registro Eliminado Correctamente");
				}
				else if(data==2)
				{
					message(4,"Error al Eliminar el Registro");
				}
				else
				{
					message(4,data);
				}
			});
		}
		function message(tipo,mensaje)
		{
			switch (tipo)
			{
				case(1):
					alerta='<div id="Message" class="alert alert-success alert-dismissable"><button type="button" class="close" data-dismiss="alert">&times;</button>'+mensaje+'</div>';
					break;
				case(2):
					alerta='<div id="Message" class="alert alert-info alert-dismissable"><button type="button" class="close" data-dismiss="alert">&times;</button>'+mensaje+'</div>';
					break;
				case(3):
					alerta='<div id="Message" class="alert alert-warning alert-dismissable"><button type="button" class="close" data-dismiss="alert">&times;</button>'+mensaje+'</div>';
					break;
				case(4):
					alerta='<div id="Message" class="alert alert-warning alert-dismissable"><button type="button" class="close" data-dismiss="alert">&times;</button>'+mensaje+'</div>';
					break;
			}
			$("#message_alerta").html(alerta);
			$("#message_alerta").fadeIn("slow");
				setTimeout(function(){
					$("#message_alerta").fadeOut("slow");
				},5000);
		}
		function cargarEstablecimiento(id)
		{
			var opciones="";
			$.post("Sede/Actualizar.php",{accion:"5"},
				function(data)
				{
					if(data!="0")
					{
						for(var i=0;i<data.length;i++)
						{
							opciones=opciones + '<option value='+data[i].idEstablecimiento+'>'+data[i].nombre+'</option>';
						}
						$("#idEstablecimiento").append(opciones);					
						$("#idEstablecimiento").val(id);
						
					}
					else
					{
						if (data=="0")
						{
							message(3,"No se encontraron Registros.");
						}
						else
						{
							message(4,data);
						}
					}
				},"json");
		}
		function cargarLocalidad(id)
		{
			var opciones="";
			$.post("Sede/Actualizar.php",{accion:"6"},
				function(data)
				{
					if(data!="0")
					{
						for(var i=0;i<data.length;i++)
						{
							opciones=opciones + '<option value='+data[i].idLocalidad+'>'+data[i].nombre+'</option>';
						}
						$("#idLocalidad").append(opciones);					
						$("#idLocalidad").val(id);
						
					}
					else
					{
						if (data=="0")
						{
							message(3,"No se encontraron Registros.");
						}
						else
						{
							message(4,data);
						}
					}
				},"json");
		}
		function cargarUPZ(id)
		{
			var opciones="";
			$.post("Sede/Actualizar.php",{accion:"7"},
				function(data)
				{
					if(data!="0")
					{
						for(var i=0;i<data.length;i++)
						{
							opciones=opciones + '<option value='+data[i].idUPZ+'>'+data[i].nombre+'</option>';
						}
						$("#idUPZ").append(opciones);					
						$("#idUPZ").val(id);
						
					}
					else
					{
						if (data=="0")
						{
							message(3,"No se encontraron Registros.");
						}
						else
						{
							message(4,data);
						}
					}
				},"json");
		}
	</script>
</body>
</html>
