<?php
	class Categorias
	{
		function InsertarCategorias($nombre)
		{
			try
			{
				include ("config.php");
				$Sentencia = "INSERT INTO categoria SET nombre=:nombre";
				$stmtRegistro = $con->prepare($Sentencia);
				$nombre =htmlspecialchars(strip_tags($nombre));
				$stmtRegistro->bindParam(":nombre",$nombre);
				if($stmtRegistro->execute())
				{
					echo "1";
				}
				else
				{
					echo "2";
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function ModificarCategorias($idCategoria,$nombre)
		{
			try
			{
				include ("config.php");
				$Sentencia = "UPDATE categoria SET nombre=:nombre Where idCategoria=:idCategoria";
				$stmtRegistro = $con->prepare($Sentencia);
				$nombre =htmlspecialchars(strip_tags($nombre));
				$stmtRegistro->bindParam(":idCategoria",$idCategoria);
				$stmtRegistro->bindParam(":nombre",$nombre);
				if($stmtRegistro->execute())
				{
					echo "3";
				}
				else
				{
					echo "2";
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function EliminarCategorias($id)
		{
			try
			{
				include ("config.php");
				$Sentencia="DELETE FROM categoria Where idCategoria=?";
				$stmtRegistro = $con->prepare($Sentencia);
				$stmtRegistro->bindParam(1, $id);
				if($stmtRegistro->execute())
				{
					echo "1";
				}
				else
				{
					echo "2";
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function ConsultarCategorias($id)
		{
			try
			{
				include ("config.php");
				$Sentencia="SELECT idCategoria,nombre FROM categoria Where idCategoria=?";
				$stmtRegistro = $con->prepare($Sentencia);
				$stmtRegistro->bindParam(1, $id);
				$stmtRegistro->execute();
				$validar = 1;
				if($validar>0)
				{
					$rowRegistro = $stmtRegistro->fetch(PDO::FETCH_ASSOC);
					extract($rowRegistro);
					$arr= array(
						"idCategoria" =>utf8_encode($idCategoria),
						"nombre" =>utf8_encode($nombre),
					);
					//return $arr;
					echo '{"idCategoria":"'.$arr['idCategoria'].'",';
					echo '"nombre":"'.$arr['nombre'].'"}'; 
				}
				else
				{
					return 0;
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function LlenarTabla()
		{
			try
			{
				include ("config.php");
				$Sentencia="SELECT idCategoria,nombre FROM categoria";
				$stmtRegistro = $con->prepare($Sentencia);
				$stmtRegistro->execute();
				$validar = 1;
				if($validar>0)
				{
					while ($rowRegistro = $stmtRegistro->fetch(PDO::FETCH_ASSOC))
					{
						extract($rowRegistro);
						$arr[]= array(
						"idCategoria" =>utf8_encode($idCategoria),
						"nombre" =>utf8_encode($nombre),
						);
					}
					//return $arr;
					$val = 1;
					$resultado = count($arr);
					echo '[';
					foreach ($arr as $valor) {
						echo '{"idCategoria":"'.$valor['idCategoria'].'",';
						echo '"nombre":"'.$valor['nombre'].'"}'; 
						if($resultado > $val)
						{
							echo ',';
						}
						$val = $val + 1;
					}
					echo ']';
				}
				else
				{
					return 0;
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function InsertarCategoriasMasivo($idCategoria,$nombre)
		{
			try
			{
				include ("config.php");
				$Sentencia = "INSERT INTO categoria SET idCategoria=:idCategoria,nombre=:nombre";
				$stmtRegistro = $con->prepare($Sentencia);
				$nombre =htmlspecialchars(strip_tags($nombre));
				$stmtRegistro->bindParam(":idCategoria",$idCategoria);
				$stmtRegistro->bindParam(":nombre",$nombre);
				if($stmtRegistro->execute())
				{
					echo "1";
				}
				else
				{
					echo "2";
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
	}
?>
