<?php
	class ContratoTiempos
	{
		function InsertarContratoTiempos($plazoInicial,$plazoAdicional,$tiempoSuspendido,$idContrato)
		{
			try
			{
				include ("config.php");
				$Sentencia = "INSERT INTO contratotiempos SET plazoInicial=:plazoInicial,plazoAdicional=:plazoAdicional,tiempoSuspendido=:tiempoSuspendido,idContrato=:idContrato";
				$stmtRegistro = $con->prepare($Sentencia);
				$plazoInicial =htmlspecialchars(strip_tags($plazoInicial));
				$plazoAdicional =htmlspecialchars(strip_tags($plazoAdicional));
				$tiempoSuspendido =htmlspecialchars(strip_tags($tiempoSuspendido));
				$idContrato =htmlspecialchars(strip_tags($idContrato));
				$stmtRegistro->bindParam(":plazoInicial",$plazoInicial);
				$stmtRegistro->bindParam(":plazoAdicional",$plazoAdicional);
				$stmtRegistro->bindParam(":tiempoSuspendido",$tiempoSuspendido);
				$stmtRegistro->bindParam(":idContrato",$idContrato);
				if($stmtRegistro->execute())
				{
					echo "1";
				}
				else
				{
					echo "2";
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function ModificarContratoTiempos($idContratoTiempos,$plazoInicial,$plazoAdicional,$tiempoSuspendido,$idContrato)
		{
			try
			{
				include ("config.php");
				$Sentencia = "UPDATE contratotiempos SET plazoInicial=:plazoInicial,plazoAdicional=:plazoAdicional,tiempoSuspendido=:tiempoSuspendido,idContrato=:idContrato Where idContratoTiempos=:idContratoTiempos";
				$stmtRegistro = $con->prepare($Sentencia);
				$plazoInicial =htmlspecialchars(strip_tags($plazoInicial));
				$plazoAdicional =htmlspecialchars(strip_tags($plazoAdicional));
				$tiempoSuspendido =htmlspecialchars(strip_tags($tiempoSuspendido));
				$idContrato =htmlspecialchars(strip_tags($idContrato));
				$stmtRegistro->bindParam(":idContratoTiempos",$idContratoTiempos);
				$stmtRegistro->bindParam(":plazoInicial",$plazoInicial);
				$stmtRegistro->bindParam(":plazoAdicional",$plazoAdicional);
				$stmtRegistro->bindParam(":tiempoSuspendido",$tiempoSuspendido);
				$stmtRegistro->bindParam(":idContrato",$idContrato);
				if($stmtRegistro->execute())
				{
					echo "3";
				}
				else
				{
					echo "2";
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function EliminarContratoTiempos($id)
		{
			try
			{
				include ("config.php");
				$Sentencia="DELETE FROM contratotiempos Where idContratoTiempos=?";
				$stmtRegistro = $con->prepare($Sentencia);
				$stmtRegistro->bindParam(1, $id);
				if($stmtRegistro->execute())
				{
					echo "1";
				}
				else
				{
					echo "2";
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function ConsultarContratoTiempos($id)
		{
			try
			{
				include ("config.php");
				$Sentencia="SELECT idContratoTiempos,plazoInicial,plazoAdicional,tiempoSuspendido,idContrato FROM contratotiempos Where idContratoTiempos=?";
				$stmtRegistro = $con->prepare($Sentencia);
				$stmtRegistro->bindParam(1, $id);
				$stmtRegistro->execute();
				$validar = 1;
				if($validar>0)
				{
					$rowRegistro = $stmtRegistro->fetch(PDO::FETCH_ASSOC);
					extract($rowRegistro);
					$arr= array(
						"idContratoTiempos" =>utf8_encode($idContratoTiempos),
						"plazoInicial" =>utf8_encode($plazoInicial),
						"plazoAdicional" =>utf8_encode($plazoAdicional),
						"tiempoSuspendido" =>utf8_encode($tiempoSuspendido),
						"idContrato" =>utf8_encode($idContrato),
					);
					//return $arr;
					echo '{"idContratoTiempos":"'.$arr['idContratoTiempos'].'",';
					echo '"plazoInicial":"'.$arr['plazoInicial'].'",';
					echo '"plazoAdicional":"'.$arr['plazoAdicional'].'",';
					echo '"tiempoSuspendido":"'.$arr['tiempoSuspendido'].'",';
					echo '"idContrato":"'.$arr['idContrato'].'"}';
				}
				else
				{
					return 0;
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function LlenarTabla()
		{
			try
			{
				include ("config.php");
				$Sentencia="SELECT C.idContratoTiempos,C.plazoInicial,C.plazoAdicional,C.tiempoSuspendido,C.idContrato,B.numeroContrato FROM contratotiempos C INNER JOIN contratodatosbasicos B ON C.idContrato = B.idContrato";
				$stmtRegistro = $con->prepare($Sentencia);
				$stmtRegistro->execute();
				$validar = 1;
				if($validar>0)
				{
					while ($rowRegistro = $stmtRegistro->fetch(PDO::FETCH_ASSOC))
					{
						extract($rowRegistro);
						$arr[]= array(
						"idContratoTiempos" =>utf8_encode($idContratoTiempos),
						"plazoInicial" =>utf8_encode($plazoInicial),
						"plazoAdicional" =>utf8_encode($plazoAdicional),
						"tiempoSuspendido" =>utf8_encode($tiempoSuspendido),
						"numeroContrato" =>utf8_encode($numeroContrato),
						);
					}
					//return $arr;
					$val = 1;
					$resultado = count($arr);
					echo '[';
					foreach ($arr as $valor) {
    					echo '{"idContratoTiempos":"'.$valor['idContratoTiempos'].'",';
						echo '"plazoInicial":"'.$valor['plazoInicial'].'",';
						echo '"plazoAdicional":"'.$valor['plazoAdicional'].'",';
						echo '"tiempoSuspendido":"'.$valor['tiempoSuspendido'].'",';
						echo '"numeroContrato":"'.$valor['numeroContrato'].'"}';
						if($resultado > $val)
						{
							echo ',';
						}
						$val = $val + 1;
					}
					echo ']';
				}
				else
				{
					return 0;
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function ListarContratos()
		{
			try
			{
				include ("config.php");
				$Sentencia="SELECT idcontrato,numeroContrato from contratodatosbasicos";
				$stmtRegistro = $con->prepare($Sentencia);
				$stmtRegistro->execute();
				$validar = 1;
				if($validar>0)
				{
					while ($rowRegistro = $stmtRegistro->fetch(PDO::FETCH_ASSOC))
					{
						extract($rowRegistro);
						$arr[]= array(
						"idcontrato" =>utf8_encode($idcontrato),
						"numeroContrato" =>utf8_encode($numeroContrato),
						);
					}
					//return $arr;
					$val = 1;
					$resultado = count($arr);
					echo '[';
					foreach ($arr as $valor) {
    					echo '{"idContrato":"'.$valor['idcontrato'].'",';
						echo '"numeroContrato":"'.$valor['numeroContrato'].'"}';
						if($resultado > $val)
						{
							echo ',';
						}
						$val = $val + 1;
					}
					echo ']';
				}
				else
				{
					return 0;
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
	}
?>
