<?php
	class ContratoValores
	{
		function InsertarContratoValores($valorAdiciones,$valorReconocimientos,$valorAnticipo,$valorTotalPagadoActas,$valorAmorizado,$valorRetencion,$valorTotalPagado,$saldoPorPagar,$idContrato)
		{
			try
			{
				include ("config.php");
				$Sentencia = "INSERT INTO contratovalores SET valorAdiciones=:valorAdiciones,valorReconocimientos=:valorReconocimientos,valorAnticipo=:valorAnticipo,valorTotalPagadoActas=:valorTotalPagadoActas,valorAmorizado=:valorAmorizado,valorRetencion=:valorRetencion,valorTotalPagado=:valorTotalPagado,saldoPorPagar=:saldoPorPagar,idContrato=:idContrato";
				$stmtRegistro = $con->prepare($Sentencia);
				$valorAdiciones =htmlspecialchars(strip_tags($valorAdiciones));
				$valorReconocimientos =htmlspecialchars(strip_tags($valorReconocimientos));
				$valorAnticipo =htmlspecialchars(strip_tags($valorAnticipo));
				$valorTotalPagadoActas =htmlspecialchars(strip_tags($valorTotalPagadoActas));
				$valorAmorizado =htmlspecialchars(strip_tags($valorAmorizado));
				$valorRetencion =htmlspecialchars(strip_tags($valorRetencion));
				$valorTotalPagado =htmlspecialchars(strip_tags($valorTotalPagado));
				$saldoPorPagar =htmlspecialchars(strip_tags($saldoPorPagar));
				$idContrato =htmlspecialchars(strip_tags($idContrato));
				$stmtRegistro->bindParam(":valorAdiciones",$valorAdiciones);
				$stmtRegistro->bindParam(":valorReconocimientos",$valorReconocimientos);
				$stmtRegistro->bindParam(":valorAnticipo",$valorAnticipo);
				$stmtRegistro->bindParam(":valorTotalPagadoActas",$valorTotalPagadoActas);
				$stmtRegistro->bindParam(":valorAmorizado",$valorAmorizado);
				$stmtRegistro->bindParam(":valorRetencion",$valorRetencion);
				$stmtRegistro->bindParam(":valorTotalPagado",$valorTotalPagado);
				$stmtRegistro->bindParam(":saldoPorPagar",$saldoPorPagar);
				$stmtRegistro->bindParam(":idContrato",$idContrato);
				if($stmtRegistro->execute())
				{
					echo "1";
				}
				else
				{
					echo "2";
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function ModificarContratoValores($idContratoValores,$valorAdiciones,$valorReconocimientos,$valorAnticipo,$valorTotalPagadoActas,$valorAmorizado,$valorRetencion,$valorTotalPagado,$saldoPorPagar,$idContrato)
		{
			try
			{
				include ("config.php");
				$Sentencia = "UPDATE contratovalores SET valorAdiciones=:valorAdiciones,valorReconocimientos=:valorReconocimientos,valorAnticipo=:valorAnticipo,valorTotalPagadoActas=:valorTotalPagadoActas,valorAmorizado=:valorAmorizado,valorRetencion=:valorRetencion,valorTotalPagado=:valorTotalPagado,saldoPorPagar=:saldoPorPagar,idContrato=:idContrato Where idContratoValores=:idContratoValores";
				$stmtRegistro = $con->prepare($Sentencia);
				$valorAdiciones =htmlspecialchars(strip_tags($valorAdiciones));
				$valorReconocimientos =htmlspecialchars(strip_tags($valorReconocimientos));
				$valorAnticipo =htmlspecialchars(strip_tags($valorAnticipo));
				$valorTotalPagadoActas =htmlspecialchars(strip_tags($valorTotalPagadoActas));
				$valorAmorizado =htmlspecialchars(strip_tags($valorAmorizado));
				$valorRetencion =htmlspecialchars(strip_tags($valorRetencion));
				$valorTotalPagado =htmlspecialchars(strip_tags($valorTotalPagado));
				$saldoPorPagar =htmlspecialchars(strip_tags($saldoPorPagar));
				$idContrato =htmlspecialchars(strip_tags($idContrato));
				$stmtRegistro->bindParam(":idContratoValores",$idContratoValores);
				$stmtRegistro->bindParam(":valorAdiciones",$valorAdiciones);
				$stmtRegistro->bindParam(":valorReconocimientos",$valorReconocimientos);
				$stmtRegistro->bindParam(":valorAnticipo",$valorAnticipo);
				$stmtRegistro->bindParam(":valorTotalPagadoActas",$valorTotalPagadoActas);
				$stmtRegistro->bindParam(":valorAmorizado",$valorAmorizado);
				$stmtRegistro->bindParam(":valorRetencion",$valorRetencion);
				$stmtRegistro->bindParam(":valorTotalPagado",$valorTotalPagado);
				$stmtRegistro->bindParam(":saldoPorPagar",$saldoPorPagar);
				$stmtRegistro->bindParam(":idContrato",$idContrato);
				if($stmtRegistro->execute())
				{
					echo "3";
				}
				else
				{
					echo "2";
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function EliminarContratoValores($id)
		{
			try
			{
				include ("config.php");
				$Sentencia="DELETE FROM contratovalores Where idContratoValores=?";
				$stmtRegistro = $con->prepare($Sentencia);
				$stmtRegistro->bindParam(1, $id);
				if($stmtRegistro->execute())
				{
					echo "1";
				}
				else
				{
					echo "2";
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function ConsultarContratoValores($id)
		{
			try
			{
				include ("config.php");
				$Sentencia="SELECT idContratoValores,valorAdiciones,valorReconocimientos,valorAnticipo,valorTotalPagadoActas,valorAmorizado,valorRetencion,valorTotalPagado,saldoPorPagar,idContrato FROM contratovalores Where idContratoValores=?";
				$stmtRegistro = $con->prepare($Sentencia);
				$stmtRegistro->bindParam(1, $id);
				$stmtRegistro->execute();
				$validar = 1;
				if($validar>0)
				{
					$rowRegistro = $stmtRegistro->fetch(PDO::FETCH_ASSOC);
					extract($rowRegistro);
					$arr= array(
						"idContratoValores" =>utf8_encode($idContratoValores),
						"valorAdiciones" =>utf8_encode($valorAdiciones),
						"valorReconocimientos" =>utf8_encode($valorReconocimientos),
						"valorAnticipo" =>utf8_encode($valorAnticipo),
						"valorTotalPagadoActas" =>utf8_encode($valorTotalPagadoActas),
						"valorAmorizado" =>utf8_encode($valorAmorizado),
						"valorRetencion" =>utf8_encode($valorRetencion),
						"valorTotalPagado" =>utf8_encode($valorTotalPagado),
						"saldoPorPagar" =>utf8_encode($saldoPorPagar),
						"idContrato" =>utf8_encode($idContrato),
					);
					//return $arr;
					echo '{"idContratoValores":"'.$arr['idContratoValores'].'",';
					echo '"valorAdiciones":"'.$arr['valorAdiciones'].'",';
					echo '"valorReconocimientos":"'.$arr['valorReconocimientos'].'",';
					echo '"valorAnticipo":"'.$arr['valorAnticipo'].'",';
					echo '"valorTotalPagadoActas":"'.$arr['valorTotalPagadoActas'].'",';
					echo '"valorAmorizado":"'.$arr['valorAmorizado'].'",';
					echo '"valorRetencion":"'.$arr['valorRetencion'].'",';
					echo '"valorTotalPagado":"'.$arr['valorTotalPagado'].'",';
					echo '"saldoPorPagar":"'.$arr['saldoPorPagar'].'",';
					echo '"idContrato":"'.$arr['idContrato'].'"}';
				}
				else
				{
					return 0;
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function LlenarTabla()
		{
			try
			{
				include ("config.php");
				$Sentencia="SELECT C.idContratoValores,C.valorAdiciones,C.valorReconocimientos,C.valorAnticipo,C.valorTotalPagadoActas,C.valorAmorizado,C.valorRetencion,C.valorTotalPagado, C.saldoPorPagar,C.idContrato,B.numeroContrato FROM contratovalores C INNER JOIN contratodatosbasicos B ON C.idContrato = B.idContrato";
				$stmtRegistro = $con->prepare($Sentencia);
				$stmtRegistro->execute();
				$validar = 1;
				if($validar>0)
				{
					while ($rowRegistro = $stmtRegistro->fetch(PDO::FETCH_ASSOC))
					{
						extract($rowRegistro);
						$arr[]= array(
						"idContratoValores" =>utf8_encode($idContratoValores),
						"valorAdiciones" =>utf8_encode($valorAdiciones),
						"valorReconocimientos" =>utf8_encode($valorReconocimientos),
						"valorAnticipo" =>utf8_encode($valorAnticipo),
						"valorTotalPagadoActas" =>utf8_encode($valorTotalPagadoActas),
						"valorAmorizado" =>utf8_encode($valorAmorizado),
						"valorRetencion" =>utf8_encode($valorRetencion),
						"valorTotalPagado" =>utf8_encode($valorTotalPagado),
						"saldoPorPagar" =>utf8_encode($saldoPorPagar),
						"numeroContrato" =>utf8_encode($numeroContrato),
						);
					}
					//return $arr;
					$val = 1;
					$resultado = count($arr);
					echo '[';
					foreach ($arr as $valor) {
    					echo '{"idContratoValores":"'.$valor['idContratoValores'].'",';
						echo '"valorAdiciones":"'.$valor['valorAdiciones'].'",';
						echo '"valorReconocimientos":"'.$valor['valorReconocimientos'].'",';
						echo '"valorAnticipo":"'.$valor['valorAnticipo'].'",';
						echo '"valorTotalPagadoActas":"'.$valor['valorTotalPagadoActas'].'",';
						echo '"valorAmorizado":"'.$valor['valorAmorizado'].'",';
						echo '"valorRetencion":"'.$valor['valorRetencion'].'",';
						echo '"valorTotalPagado":"'.$valor['valorTotalPagado'].'",';
						echo '"saldoPorPagar":"'.$valor['saldoPorPagar'].'",';
						echo '"numeroContrato":"'.$valor['numeroContrato'].'"}';
						if($resultado > $val)
						{
							echo ',';
						}
						$val = $val + 1;
					}
					echo ']';
				}
				else
				{
					return 0;
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function ListarContratos()
		{
			try
			{
				include ("config.php");
				$Sentencia="SELECT idcontrato,numeroContrato from contratodatosbasicos";
				$stmtRegistro = $con->prepare($Sentencia);
				$stmtRegistro->execute();
				$validar = 1;
				if($validar>0)
				{
					while ($rowRegistro = $stmtRegistro->fetch(PDO::FETCH_ASSOC))
					{
						extract($rowRegistro);
						$arr[]= array(
						"idcontrato" =>utf8_encode($idcontrato),
						"numeroContrato" =>utf8_encode($numeroContrato),
						);
					}
					//return $arr;
					$val = 1;
					$resultado = count($arr);
					echo '[';
					foreach ($arr as $valor) {
    					echo '{"idContrato":"'.$valor['idcontrato'].'",';
						echo '"numeroContrato":"'.$valor['numeroContrato'].'"}';
						if($resultado > $val)
						{
							echo ',';
						}
						$val = $val + 1;
					}
					echo ']';
				}
				else
				{
					return 0;
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
	}
?>
