<?php
	class Establecimiento
	{
		function InsertarEstablecimiento($idEstablecimiento,$nombre,$numeroIdentificacion,$codigoDane,$clase,$naturalezaJuridica,$estado)
		{
			try
			{
				include ("config.php");
				$Sentencia = "INSERT INTO establecimiento SET idEstablecimiento=:idEstablecimiento,nombre=:nombre,numeroIdentificacion=:numeroIdentificacion,codigoDane=:codigoDane,clase=:clase,naturalezaJuridica=:naturalezaJuridica,estado=:estado";
				$stmtRegistro = $con->prepare($Sentencia);
				$idEstablecimiento =htmlspecialchars(strip_tags($idEstablecimiento));
				$nombre =htmlspecialchars(strip_tags($nombre));
				$numeroIdentificacion =htmlspecialchars(strip_tags($numeroIdentificacion));
				$codigoDane =htmlspecialchars(strip_tags($codigoDane));
				$clase =htmlspecialchars(strip_tags($clase));
				$naturalezaJuridica =htmlspecialchars(strip_tags($naturalezaJuridica));
				$estado =htmlspecialchars(strip_tags($estado));
				$stmtRegistro->bindParam(":idEstablecimiento",$idEstablecimiento);
				$stmtRegistro->bindParam(":nombre",$nombre);
				$stmtRegistro->bindParam(":numeroIdentificacion",$numeroIdentificacion);
				$stmtRegistro->bindParam(":codigoDane",$codigoDane);
				$stmtRegistro->bindParam(":clase",$clase);
				$stmtRegistro->bindParam(":naturalezaJuridica",$naturalezaJuridica);
				$stmtRegistro->bindParam(":estado",$estado);
				if($stmtRegistro->execute())
				{
					echo "1";
				}
				else
				{
					echo "2";
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function ModificarEstablecimiento($idEstablecimiento,$nombre,$numeroIdentificacion,$codigoDane,$clase,$naturalezaJuridica,$estado)
		{
			try
			{
				include ("config.php");
				$Sentencia = "UPDATE establecimiento SET nombre=:nombre,numeroIdentificacion=:numeroIdentificacion,codigoDane=:codigoDane,clase=:clase,naturalezaJuridica=:naturalezaJuridica,estado=:estado Where idEstablecimiento=:idEstablecimiento";
				$stmtRegistro = $con->prepare($Sentencia);
				$nombre =htmlspecialchars(strip_tags($nombre));
				$numeroIdentificacion =htmlspecialchars(strip_tags($numeroIdentificacion));
				$codigoDane =htmlspecialchars(strip_tags($codigoDane));
				$clase =htmlspecialchars(strip_tags($clase));
				$naturalezaJuridica =htmlspecialchars(strip_tags($naturalezaJuridica));
				$estado =htmlspecialchars(strip_tags($estado));
				$stmtRegistro->bindParam(":idEstablecimiento",$idEstablecimiento);
				$stmtRegistro->bindParam(":nombre",$nombre);
				$stmtRegistro->bindParam(":numeroIdentificacion",$numeroIdentificacion);
				$stmtRegistro->bindParam(":codigoDane",$codigoDane);
				$stmtRegistro->bindParam(":clase",$clase);
				$stmtRegistro->bindParam(":naturalezaJuridica",$naturalezaJuridica);
				$stmtRegistro->bindParam(":estado",$estado);
				if($stmtRegistro->execute())
				{
					echo "3";
				}
				else
				{
					echo "2";
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function EliminarEstablecimiento($id)
		{
			try
			{
				include ("config.php");
				$Sentencia="DELETE FROM establecimiento Where idEstablecimiento=?";
				$stmtRegistro = $con->prepare($Sentencia);
				$stmtRegistro->bindParam(1, $id);
				if($stmtRegistro->execute())
				{
					echo "1";
				}
				else
				{
					echo "2";
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function ConsultarEstablecimiento($id)
		{
			try
			{
				include ("config.php");
				$Sentencia="SELECT idEstablecimiento,nombre,numeroIdentificacion,codigoDane,clase,naturalezaJuridica,estado FROM establecimiento Where idEstablecimiento=?";
				$stmtRegistro = $con->prepare($Sentencia);
				$stmtRegistro->bindParam(1, $id);
				$stmtRegistro->execute();
				$validar = 1;
				if($validar>0)
				{
					$rowRegistro = $stmtRegistro->fetch(PDO::FETCH_ASSOC);
					extract($rowRegistro);
					$arr= array(
						"idEstablecimiento" =>utf8_encode($idEstablecimiento),
						"nombre" =>utf8_encode($nombre),
						"numeroIdentificacion" =>utf8_encode($numeroIdentificacion),
						"codigoDane" =>utf8_encode($codigoDane),
						"clase" =>utf8_encode($clase),
						"naturalezaJuridica" =>utf8_encode($naturalezaJuridica),
						"estado" =>utf8_encode($estado),
					);
					//return $arr;
					echo '{"idEstablecimiento":"'.$arr['idEstablecimiento'].'",';
					echo '"nombre":"'.$arr['nombre'].'",';
					echo '"numeroIdentificacion":"'.$arr['numeroIdentificacion'].'",';
					echo '"codigoDane":"'.$arr['codigoDane'].'",';
					echo '"clase":"'.$arr['clase'].'",';
					echo '"naturalezaJuridica":"'.$arr['naturalezaJuridica'].'",';
					echo '"estado":"'.$arr['estado'].'"}';
				}
				else
				{
					return 0;
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function LlenarTabla()
		{
			try
			{
				include ("config.php");
				$Sentencia="SELECT idEstablecimiento,nombre,numeroIdentificacion,codigoDane,clase,naturalezaJuridica,estado FROM establecimiento";
				$stmtRegistro = $con->prepare($Sentencia);
				$stmtRegistro->execute();
				$validar = 1;
				if($validar>0)
				{
					while ($rowRegistro = $stmtRegistro->fetch(PDO::FETCH_ASSOC))
					{
						extract($rowRegistro);
						$arr[]= array(
						"idEstablecimiento" =>utf8_encode($idEstablecimiento),
						"nombre" =>utf8_encode($nombre),
						"numeroIdentificacion" =>utf8_encode($numeroIdentificacion),
						"codigoDane" =>utf8_encode($codigoDane),
						"clase" =>utf8_encode($clase),
						"naturalezaJuridica" =>utf8_encode($naturalezaJuridica),
						"estado" =>utf8_encode($estado),
						);
					}
					//return $arr;
					$val = 1;
					$resultado = count($arr);
					echo '[';
					foreach ($arr as $valor) {
    					echo '{"idEstablecimiento":"'.$valor['idEstablecimiento'].'",';
						echo '"nombre":"'.$valor['nombre'].'",';
						echo '"numeroIdentificacion":"'.$valor['numeroIdentificacion'].'",';
						echo '"codigoDane":"'.$valor['codigoDane'].'",';
						echo '"clase":"'.$valor['clase'].'",';
						echo '"naturalezaJuridica":"'.$valor['naturalezaJuridica'].'",';
						echo '"estado":"'.$valor['estado'].'"}';
						if($resultado > $val)
						{
							echo ',';
						}
						$val = $val + 1;
					}
					echo ']';
				}
				else
				{
					return 0;
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
	}
?>
