<?php
	class Estado
	{
		function InsertarEstado($nombre)
		{
			try
			{
				include ("config.php");
				$Sentencia = "INSERT INTO estado SET nombre=:nombre";
				$stmtRegistro = $con->prepare($Sentencia);
				$nombre =htmlspecialchars(strip_tags($nombre));
				$stmtRegistro->bindParam(":nombre",$nombre);
				if($stmtRegistro->execute())
				{
					echo "1";
				}
				else
				{
					echo "2";
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function ModificarEstado($idEstado,$nombre)
		{
			try
			{
				include ("config.php");
				$Sentencia = "UPDATE estado SET nombre=:nombre Where idEstado=:idEstado";
				$stmtRegistro = $con->prepare($Sentencia);
				$nombre =htmlspecialchars(strip_tags($nombre));
				$stmtRegistro->bindParam(":idEstado",$idEstado);
				$stmtRegistro->bindParam(":nombre",$nombre);
				if($stmtRegistro->execute())
				{
					echo "3";
				}
				else
				{
					echo "2";
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function EliminarEstado($id)
		{
			try
			{
				include ("config.php");
				$Sentencia="DELETE FROM estado Where idEstado=?";
				$stmtRegistro = $con->prepare($Sentencia);
				$stmtRegistro->bindParam(1, $id);
				if($stmtRegistro->execute())
				{
					echo "1";
				}
				else
				{
					echo "2";
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function ConsultarEstado($id)
		{
			try
			{
				include ("config.php");
				$Sentencia="SELECT idEstado,nombre FROM estado Where idEstado=?";
				$stmtRegistro = $con->prepare($Sentencia);
				$stmtRegistro->bindParam(1, $id);
				$stmtRegistro->execute();
				$validar = 1;
				if($validar>0)
				{
					$rowRegistro = $stmtRegistro->fetch(PDO::FETCH_ASSOC);
					extract($rowRegistro);
					$arr= array(
						"idEstado" =>($idEstado),
						"nombre" =>utf8_encode($nombre),
					);
					//return $arr;
					echo '{"idEstado":"'.$arr['idEstado'].'",';
					echo '"nombre":"'.$arr['nombre'].'"}'; 
				}
				else
				{
					return 0;
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function LlenarTabla()
		{
			try
			{
				include ("config.php");
				$Sentencia="SELECT idEstado,nombre FROM estado";
				$stmtRegistro = $con->prepare($Sentencia);
				$stmtRegistro->execute();
				$validar = 1;
				if($validar>0)
				{
					while ($rowRegistro = $stmtRegistro->fetch(PDO::FETCH_ASSOC))
					{
						extract($rowRegistro);
						$arr[]= array(
						"idEstado" =>($idEstado),
						"nombre" =>utf8_encode($nombre),
						);
					}
					//return $arr;
					$val = 1;
					$resultado = count($arr);
					echo '[';
					foreach ($arr as $valor) {
						echo '{"idEstado":"'.$valor['idEstado'].'",';
						echo '"nombre":"'.$valor['nombre'].'"}'; 
						if($resultado > $val)
						{
							echo ',';
						}
						$val = $val + 1;
					}
					echo ']';
				}
				else
				{
					return 0;
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function InsertarEstadoMasivo($idEstado,$nombre)
		{
			try
			{
				include ("config.php");
				$Sentencia = "INSERT INTO estado SET idEstado=:idEstado,nombre=:nombre";
				$stmtRegistro = $con->prepare($Sentencia);
				$nombre =htmlspecialchars(strip_tags($nombre));
				$stmtRegistro->bindParam(":idEstado",$idEstado);
				$stmtRegistro->bindParam(":nombre",$nombre);
				if($stmtRegistro->execute())
				{
					echo "1";
				}
				else
				{
					echo "2";
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
	}
?>
