<?php
	class Financiacion
	{
		function InsertarFinanciacion($nombre)
		{
			try
			{
				include ("config.php");
				$Sentencia = "INSERT INTO financiacion SET nombre=:nombre";
				$stmtRegistro = $con->prepare($Sentencia);
				$nombre =htmlspecialchars(strip_tags($nombre));
				$stmtRegistro->bindParam(":nombre",$nombre);
				if($stmtRegistro->execute())
				{
					echo "1";
				}
				else
				{
					echo "2";
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function ModificarFinanciacion($idFinanciacion,$nombre)
		{
			try
			{
				include ("config.php");
				$Sentencia = "UPDATE financiacion SET nombre=:nombre Where idFinanciacion=:idFinanciacion";
				$stmtRegistro = $con->prepare($Sentencia);
				$nombre =htmlspecialchars(strip_tags($nombre));
				$stmtRegistro->bindParam(":idFinanciacion",$idFinanciacion);
				$stmtRegistro->bindParam(":nombre",$nombre);
				if($stmtRegistro->execute())
				{
					echo "3";
				}
				else
				{
					echo "2";
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function EliminarFinanciacion($id)
		{
			try
			{
				include ("config.php");
				$Sentencia="DELETE FROM financiacion Where idFinanciacion=?";
				$stmtRegistro = $con->prepare($Sentencia);
				$stmtRegistro->bindParam(1, $id);
				if($stmtRegistro->execute())
				{
					echo "1";
				}
				else
				{
					echo "2";
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function ConsultarFinanciacion($id)
		{
			try
			{
				include ("config.php");
				$Sentencia="SELECT idFinanciacion,nombre FROM financiacion Where idFinanciacion=?";
				$stmtRegistro = $con->prepare($Sentencia);
				$stmtRegistro->bindParam(1, $id);
				$stmtRegistro->execute();
				$validar = 1;
				if($validar>0)
				{
					$rowRegistro = $stmtRegistro->fetch(PDO::FETCH_ASSOC);
					extract($rowRegistro);
					$arr= array(
						"idFinanciacion" =>utf8_encode($idFinanciacion),
						"nombre" =>utf8_encode($nombre),
					);
					//return $arr;
					echo '{"idFinanciacion":"'.$arr['idFinanciacion'].'",';
					echo '"nombre":"'.$arr['nombre'].'"}'; 
				}
				else
				{
					return 0;
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function LlenarTabla()
		{
			try
			{
				include ("config.php");
				$Sentencia="SELECT idFinanciacion,nombre FROM financiacion";
				$stmtRegistro = $con->prepare($Sentencia);
				$stmtRegistro->execute();
				$validar = 1;
				if($validar>0)
				{
					while ($rowRegistro = $stmtRegistro->fetch(PDO::FETCH_ASSOC))
					{
						extract($rowRegistro);
						$arr[]= array(
						"idFinanciacion" =>utf8_encode($idFinanciacion),
						"nombre" =>utf8_encode($nombre),
						);
					}
					//return $arr;
					$val = 1;
					$resultado = count($arr);
					echo '[';
					foreach ($arr as $valor) {
						echo '{"idFinanciacion":"'.$valor['idFinanciacion'].'",';
						echo '"nombre":"'.$valor['nombre'].'"}'; 
						if($resultado > $val)
						{
							echo ',';
						}
						$val = $val + 1;
					}
					echo ']';
				}
				else
				{
					return 0;
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function InsertarFinanciacionMasivo($idFinanciacion,$nombre)
		{
			try
			{
				include ("config.php");
				$Sentencia = "INSERT INTO financiacion SET idFinanciacion=:idFinanciacion,nombre=:nombre";
				$stmtRegistro = $con->prepare($Sentencia);
				$nombre =htmlspecialchars(strip_tags($nombre));
				$stmtRegistro->bindParam(":idFinanciacion",$idFinanciacion);
				$stmtRegistro->bindParam(":nombre",$nombre);
				if($stmtRegistro->execute())
				{
					echo "1";
				}
				else
				{
					echo "2";
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
	}
?>
