<?php
	class Localidad
	{
		function InsertarLocalidad($numeroLocalidad,$nombreLocalidad)
		{
			try
			{
				include ("config.php");
				$Sentencia = "INSERT INTO localidad SET numeroLocalidad=:numeroLocalidad,nombreLocalidad=:nombreLocalidad";
				$stmtRegistro = $con->prepare($Sentencia);
				$numeroLocalidad =htmlspecialchars(strip_tags($numeroLocalidad));
				$nombreLocalidad =htmlspecialchars(strip_tags($nombreLocalidad));
				$stmtRegistro->bindParam(":numeroLocalidad",$numeroLocalidad);
				$stmtRegistro->bindParam(":nombreLocalidad",$nombreLocalidad);
				if($stmtRegistro->execute())
				{
					echo "1";
				}
				else
				{
					echo "2";
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function ModificarLocalidad($idLocalidad,$numeroLocalidad,$nombreLocalidad)
		{
			try
			{
				include ("config.php");
				$Sentencia = "UPDATE localidad SET numeroLocalidad=:numeroLocalidad,nombreLocalidad=:nombreLocalidad Where idLocalidad=:idLocalidad";
				$stmtRegistro = $con->prepare($Sentencia);
				$numeroLocalidad =htmlspecialchars(strip_tags($numeroLocalidad));
				$nombreLocalidad =htmlspecialchars(strip_tags($nombreLocalidad));
				$stmtRegistro->bindParam(":idLocalidad",$idLocalidad);
				$stmtRegistro->bindParam(":numeroLocalidad",$numeroLocalidad);
				$stmtRegistro->bindParam(":nombreLocalidad",$nombreLocalidad);
				if($stmtRegistro->execute())
				{
					echo "3";
				}
				else
				{
					echo "2";
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function EliminarLocalidad($id)
		{
			try
			{
				include ("config.php");
				$Sentencia="DELETE FROM localidad Where idLocalidad=?";
				$stmtRegistro = $con->prepare($Sentencia);
				$stmtRegistro->bindParam(1, $id);
				if($stmtRegistro->execute())
				{
					echo "1";
				}
				else
				{
					echo "2";
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function ConsultarLocalidad($id)
		{
			try
			{
				include ("config.php");
				$Sentencia="SELECT idLocalidad,numeroLocalidad,nombreLocalidad FROM localidad Where idLocalidad=?";
				$stmtRegistro = $con->prepare($Sentencia);
				$stmtRegistro->bindParam(1, $id);
				$stmtRegistro->execute();
				$validar = 1;
				if($validar>0)
				{
					$rowRegistro = $stmtRegistro->fetch(PDO::FETCH_ASSOC);
					extract($rowRegistro);
					$arr= array(
						"idLocalidad" =>utf8_encode($idLocalidad),
						"numeroLocalidad" =>utf8_encode($numeroLocalidad),
						"nombreLocalidad" =>utf8_encode($nombreLocalidad),
					);
					//return $arr;
					echo '{"idLocalidad":"'.$arr['idLocalidad'].'",';
					echo '"numeroLocalidad":"'.$arr['numeroLocalidad'].'",';
					echo '"nombreLocalidad":"'.$arr['nombreLocalidad'].'"}';
				}
				else
				{
					return 0;
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function LlenarTabla()
		{
			try
			{
				include ("config.php");
				$Sentencia="SELECT idLocalidad,numeroLocalidad,nombreLocalidad FROM localidad";
				$stmtRegistro = $con->prepare($Sentencia);
				$stmtRegistro->execute();
				$validar = 1;
				if($validar>0)
				{
					while ($rowRegistro = $stmtRegistro->fetch(PDO::FETCH_ASSOC))
					{
						extract($rowRegistro);
						$arr[]= array(
						"idLocalidad" =>utf8_encode($idLocalidad),
						"numeroLocalidad" =>utf8_encode($numeroLocalidad),
						"nombreLocalidad" =>utf8_encode($nombreLocalidad),
						);
					}
					//return $arr;
					$val = 1;
					$resultado = count($arr);
					echo '[';
					foreach ($arr as $valor) {
    					echo '{"idLocalidad":"'.$valor['idLocalidad'].'",';
						echo '"numeroLocalidad":"'.$valor['numeroLocalidad'].'",';
						echo '"nombreLocalidad":"'.$valor['nombreLocalidad'].'"}';
						if($resultado > $val)
						{
							echo ',';
						}
						$val = $val + 1;
					}
					echo ']';
				}
				else
				{
					return 0;
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function Reporte()
		{
			try
			{
				include ("config.php");
				$Sentencia="SELECT s.idSede,l.numeroLocalidad,l.nombreLocalidad,COUNT(s.idSede) AS Sede FROM sede s INNER JOIN establecimiento e ON s.idEstablecimiento = e.idEstablecimiento INNER JOIN localidad l ON s.idLocalidad = l.idLocalidad GROUP BY s.idLocalidad";
				$stmtRegistro = $con->prepare($Sentencia);
				$stmtRegistro->execute();
				$validar = 1;
				if($validar>0)
				{
					while ($rowRegistro = $stmtRegistro->fetch(PDO::FETCH_ASSOC))
					{
						extract($rowRegistro);
						$arr[]= array(
						"numeroLocalidad" =>utf8_encode($numeroLocalidad),
						"nombreLocalidad" =>utf8_encode($nombreLocalidad),
						"Sede" =>utf8_encode($Sede),
						);
					}
					//return $arr;
					$val = 1;
					$resultado = count($arr);
					echo '[';
					foreach ($arr as $valor) {
    					echo '{"numeroLocalidad":"'.$valor['numeroLocalidad'].'",';
						echo '"nombreLocalidad":"'.$valor['nombreLocalidad'].'",';
						echo '"Sede":"'.$valor['Sede'].'"}';
						if($resultado > $val)
						{
							echo ',';
						}
						$val = $val + 1;
					}
					echo ']';
				}
				else
				{
					return 0;
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
	}
?>
