<?php
	class Meta
	{
		function InsertarMeta($nombre)
		{
			try
			{
				include ("config.php");
				$Sentencia = "INSERT INTO meta SET nombre=:nombre";
				$stmtRegistro = $con->prepare($Sentencia);
				$nombre =htmlspecialchars(strip_tags($nombre));
				$stmtRegistro->bindParam(":nombre",$nombre);
				if($stmtRegistro->execute())
				{
					echo "1";
				}
				else
				{
					echo "2";
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function ModificarMeta($idMeta,$nombre)
		{
			try
			{
				include ("config.php");
				$Sentencia = "UPDATE meta SET nombre=:nombre Where idMeta=:idMeta";
				$stmtRegistro = $con->prepare($Sentencia);
				$nombre =htmlspecialchars(strip_tags($nombre));
				$stmtRegistro->bindParam(":idMeta",$idMeta);
				$stmtRegistro->bindParam(":nombre",$nombre);
				if($stmtRegistro->execute())
				{
					echo "3";
				}
				else
				{
					echo "2";
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function EliminarMeta($id)
		{
			try
			{
				include ("config.php");
				$Sentencia="DELETE FROM meta Where idMeta=?";
				$stmtRegistro = $con->prepare($Sentencia);
				$stmtRegistro->bindParam(1, $id);
				if($stmtRegistro->execute())
				{
					echo "1";
				}
				else
				{
					echo "2";
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function ConsultarMeta($id)
		{
			try
			{
				include ("config.php");
				$Sentencia="SELECT idMeta,nombre FROM meta Where idMeta=?";
				$stmtRegistro = $con->prepare($Sentencia);
				$stmtRegistro->bindParam(1, $id);
				$stmtRegistro->execute();
				$validar = $stmtRegistro->rowCount();
				if($validar>0)
				{
					$rowRegistro = $stmtRegistro->fetch(PDO::FETCH_ASSOC);
					extract($rowRegistro);
					$arr= array(
						"idMeta" =>($idMeta),
						"nombre" =>utf8_encode($nombre),
					);
					//return $arr;
					echo '{"idMeta":"'.$arr['idMeta'].'",';
					echo '"nombre":"'.$arr['nombre'].'"}'; 
				}
				else
				{
					return 0;
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function LlenarTabla()
		{
			try
			{
				include ("config.php");
				$Sentencia="SELECT idMeta,nombre FROM meta";
				$stmtRegistro = $con->prepare($Sentencia);
				$stmtRegistro->execute();
				$validar = 1;
				if($validar>0)
				{
					while ($rowRegistro = $stmtRegistro->fetch(PDO::FETCH_ASSOC))
					{
						extract($rowRegistro);
						$arr[]= array(
						"idMeta" =>($idMeta),
						"nombre" =>utf8_encode($nombre),
						);
					}
					//return $arr;
					$val = 1;
					$resultado = count($arr);
					echo '[';
					foreach ($arr as $valor) {
						echo '{"idMeta":"'.$valor['idMeta'].'",';
						echo '"nombre":"'.$valor['nombre'].'"}'; 
						if($resultado > $val)
						{
							echo ',';
						}
						$val = $val + 1;
					}
					echo ']';
				}
				else
				{
					return 0;
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function InsertarMetaMasivo($idMeta,$nombre)
		{
			try
			{
				include ("config.php");
				$Sentencia = "INSERT INTO meta SET idMeta=:idMeta,nombre=:nombre";
				$stmtRegistro = $con->prepare($Sentencia);
				$nombre =htmlspecialchars(strip_tags($nombre));
				$stmtRegistro->bindParam(":idMeta",$idMeta);
				$stmtRegistro->bindParam(":nombre",$nombre);
				if($stmtRegistro->execute())
				{
					echo "1";
				}
				else
				{
					echo "2";
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
	}
?>
