<?php
	class ProyectoInterventoria
	{
		function InsertarProyectoInterventoria($contratoInterventoria,$valorICIVA,$adicionCITVA,$valorICIVAC,$adicionCITVAC,$idProyecto)
		{
			try
			{
				include ("config.php");
				$Sentencia = "INSERT INTO proyectointerventoria SET contratoInterventoria=:contratoInterventoria,valorICIVA=:valorICIVA,adicionCITVA=:adicionCITVA,valorICIVAC=:valorICIVAC,adicionCITVAC=:adicionCITVAC,idProyecto=:idProyecto";
				$stmtRegistro = $con->prepare($Sentencia);
				$contratoInterventoria =htmlspecialchars(strip_tags($contratoInterventoria));
				$valorICIVA =htmlspecialchars(strip_tags($valorICIVA));
				$adicionCITVA =htmlspecialchars(strip_tags($adicionCITVA));
				$valorICIVAC =htmlspecialchars(strip_tags($valorICIVAC));
				$adicionCITVAC =htmlspecialchars(strip_tags($adicionCITVAC));
				$idProyecto =htmlspecialchars(strip_tags($idProyecto));
				$stmtRegistro->bindParam(":contratoInterventoria",$contratoInterventoria);
				$stmtRegistro->bindParam(":valorICIVA",$valorICIVA);
				$stmtRegistro->bindParam(":adicionCITVA",$adicionCITVA);
				$stmtRegistro->bindParam(":valorICIVAC",$valorICIVAC);
				$stmtRegistro->bindParam(":adicionCITVAC",$adicionCITVAC);
				$stmtRegistro->bindParam(":idProyecto",$idProyecto);
				if($stmtRegistro->execute())
				{
					echo "1";
				}
				else
				{
					echo "2";
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function ModificarProyectoInterventoria($idProyectoInterventoria,$contratoInterventoria,$valorICIVA,$adicionCITVA,$valorICIVAC,$adicionCITVAC,$idProyecto)
		{
			try
			{
				include ("config.php");
				$Sentencia = "UPDATE proyectointerventoria SET contratoInterventoria=:contratoInterventoria,valorICIVA=:valorICIVA,adicionCITVA=:adicionCITVA,valorICIVAC=:valorICIVAC,adicionCITVAC=:adicionCITVAC,idProyecto=:idProyecto Where idProyectoInterventoria=:idProyectoInterventoria";
				$stmtRegistro = $con->prepare($Sentencia);
				$contratoInterventoria =htmlspecialchars(strip_tags($contratoInterventoria));
				$valorICIVA =htmlspecialchars(strip_tags($valorICIVA));
				$adicionCITVA =htmlspecialchars(strip_tags($adicionCITVA));
				$valorICIVAC =htmlspecialchars(strip_tags($valorICIVAC));
				$adicionCITVAC =htmlspecialchars(strip_tags($adicionCITVAC));
				$idProyecto =htmlspecialchars(strip_tags($idProyecto));
				$stmtRegistro->bindParam(":idProyectoInterventoria",$idProyectoInterventoria);
				$stmtRegistro->bindParam(":contratoInterventoria",$contratoInterventoria);
				$stmtRegistro->bindParam(":valorICIVA",$valorICIVA);
				$stmtRegistro->bindParam(":adicionCITVA",$adicionCITVA);
				$stmtRegistro->bindParam(":valorICIVAC",$valorICIVAC);
				$stmtRegistro->bindParam(":adicionCITVAC",$adicionCITVAC);
				$stmtRegistro->bindParam(":idProyecto",$idProyecto);
				if($stmtRegistro->execute())
				{
					echo "3";
				}
				else
				{
					echo "2";
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function EliminarProyectoInterventoria($id)
		{
			try
			{
				include ("config.php");
				$Sentencia="DELETE FROM proyectointerventoria Where idProyectoInterventoria=?";
				$stmtRegistro = $con->prepare($Sentencia);
				$stmtRegistro->bindParam(1, $id);
				if($stmtRegistro->execute())
				{
					echo "1";
				}
				else
				{
					echo "2";
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function ConsultarProyectoInterventoria($id)
		{
			try
			{
				include ("config.php");
				$Sentencia="SELECT idProyectoInterventoria,contratoInterventoria,valorICIVA,adicionCITVA,valorICIVAC,adicionCITVAC,idProyecto FROM proyectointerventoria Where idProyectoInterventoria=?";
				$stmtRegistro = $con->prepare($Sentencia);
				$stmtRegistro->bindParam(1, $id);
				$stmtRegistro->execute();
				$validar = 1;
				if($validar>0)
				{
					$rowRegistro = $stmtRegistro->fetch(PDO::FETCH_ASSOC);
					extract($rowRegistro);
					$arr= array(
						"idProyectoInterventoria" =>utf8_encode($idProyectoInterventoria),
						"contratoInterventoria" =>utf8_encode($contratoInterventoria),
						"valorICIVA" =>utf8_encode($valorICIVA),
						"adicionCITVA" =>utf8_encode($adicionCITVA),
						"valorICIVAC" =>utf8_encode($valorICIVAC),
						"adicionCITVAC" =>utf8_encode($adicionCITVAC),
						"idProyecto" =>utf8_encode($idProyecto),
					);
					//return $arr;
					echo '{"idProyectoInterventoria":"'.$arr['idProyectoInterventoria'].'",';
					echo '"contratoInterventoria":"'.$arr['contratoInterventoria'].'",';
					echo '"valorICIVA":"'.$arr['valorICIVA'].'",';
					echo '"adicionCITVA":"'.$arr['adicionCITVA'].'",';
					echo '"valorICIVAC":"'.$arr['valorICIVAC'].'",';
					echo '"adicionCITVAC":"'.$arr['adicionCITVAC'].'",';					
					echo '"idProyecto":"'.$arr['idProyecto'].'"}';
				}
				else
				{
					return 0;
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function LlenarTabla()
		{
			try
			{
				include ("config.php");
				$Sentencia="SELECT idProyectoInterventoria,contratoInterventoria,valorICIVA,adicionCITVA,valorICIVAC,adicionCITVAC,proyecto.nombreProyecto idProyecto FROM proyectointerventoria inner join proyecto on proyectointerventoria.idproyecto=proyecto.idproyecto";
				$stmtRegistro = $con->prepare($Sentencia);
				$stmtRegistro->execute();
				$validar = 1;
				if($validar>0)
				{
					while ($rowRegistro = $stmtRegistro->fetch(PDO::FETCH_ASSOC))
					{
						extract($rowRegistro);
						$arr[]= array(
						"idProyectoInterventoria" =>utf8_encode($idProyectoInterventoria),
						"contratoInterventoria" =>utf8_encode($contratoInterventoria),
						"valorICIVA" =>utf8_encode($valorICIVA),
						"adicionCITVA" =>utf8_encode($adicionCITVA),
						"valorICIVAC" =>utf8_encode($valorICIVAC),
						"adicionCITVAC" =>utf8_encode($adicionCITVAC),
						"idProyecto" =>utf8_encode($idProyecto),
						);
					}
					//return $arr;
					$val = 1;
					$resultado = count($arr);
					echo '[';
					foreach ($arr as $valor) 
					{
						echo '{"idProyectoInterventoria":"'.$valor['idProyectoInterventoria'].'",';
						echo '"contratoInterventoria":"'.$valor['contratoInterventoria'].'",';
						echo '"valorICIVA":"'.$valor['valorICIVA'].'",';
						echo '"adicionCITVA":"'.$valor['adicionCITVA'].'",';
						echo '"valorICIVAC":"'.$valor['valorICIVAC'].'",';
						echo '"adicionCITVAC":"'.$valor['adicionCITVAC'].'",';
						echo '"idProyecto":"'.$valor['idProyecto'].'"}';
						
						if($resultado > $val)
						{
							echo ',';
						}
						$val = $val + 1;
					}
					echo ']';	
				}
				else
				{
					return 0;
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function InsertarProyectoInterventoriaMasivo($idProyectoInterventoria,$contratoInterventoria,$valorICIVA,$adicionCITVA,$valorICIVAC,$adicionCITVAC,$idProyecto)
		{
			try
			{
				include ("config.php");
				$Sentencia = "INSERT INTO proyectoInterventoria SET idProyectoInterventoria=:idProyectoInterventoria,contratoInterventoria=:contratoInterventoria,valorICIVA=:valorICIVA,adicionCITVA=:adicionCITVA,valorICIVAC=:valorICIVAC,adicionCITVAC=:adicionCITVAC,idProyecto=:idProyecto";
				$stmtRegistro = $con->prepare($Sentencia);
				$idProyectoInterventoria =htmlspecialchars(strip_tags($idProyectoInterventoria));
				$contratoInterventoria =htmlspecialchars(strip_tags($contratoInterventoria));
				$valorICIVA =htmlspecialchars(strip_tags($valorICIVA));
				$adicionCITVA =htmlspecialchars(strip_tags($adicionCITVA));
				$valorICIVAC =htmlspecialchars(strip_tags($valorICIVAC));
				$adicionCITVAC =htmlspecialchars(strip_tags($adicionCITVAC));
				$idProyecto =htmlspecialchars(strip_tags($idProyecto));
				$stmtRegistro->bindParam(":idProyectoInterventoria",$idProyectoInterventoria);
				$stmtRegistro->bindParam(":contratoInterventoria",$contratoInterventoria);
				$stmtRegistro->bindParam(":valorICIVA",$valorICIVA);
				$stmtRegistro->bindParam(":adicionCITVA",$adicionCITVA);
				$stmtRegistro->bindParam(":valorICIVAC",$valorICIVAC);
				$stmtRegistro->bindParam(":adicionCITVAC",$adicionCITVAC);
				$stmtRegistro->bindParam(":idProyecto",$idProyecto);
				if($stmtRegistro->execute())
				{
					echo "1";
				}
				else
				{
					echo "2";
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function ListarProyectos()
		{
			try
			{
				include ("config.php");
				$Sentencia="SELECT idproyecto,nombreProyecto from proyecto";
				$stmtRegistro = $con->prepare($Sentencia);
				$stmtRegistro->execute();
				$validar = 1;
				if($validar>0)
				{
					while ($rowRegistro = $stmtRegistro->fetch(PDO::FETCH_ASSOC))
					{
						extract($rowRegistro);
						$arr[]= array(
						"idproyecto" =>utf8_encode($idproyecto),
						"nombre" =>utf8_encode($nombreProyecto),
						);
					}
					//return $arr;
					$val = 1;
					$resultado = count($arr);
					echo '[';
					foreach ($arr as $valor) {
    					echo '{"idproyecto":"'.$valor['idproyecto'].'",';
						echo '"nombre":"'.$valor['nombre'].'"}';
						if($resultado > $val)
						{
							echo ',';
						}
						$val = $val + 1;
					}
					echo ']';
				}
				else
				{
					return 0;
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
	}
?>
