<?php
	class Sede
	{
		function InsertarSede($idSede,$idEstablecimiento,$idLocalidad,$idUPZ,$nombre,$codigoDane,$consecutivo,$orden,$sector,$zona,$direccion,$barrio,$telefono,$correoElectronico,$web,$rector,$tipoDocumentoRector,$numeroDocumentoRector,$cargo,$codigoPlantaFisica,$concesion)
		{
			try
			{
				include ("config.php");
				$Sentencia = "INSERT INTO sede SET idSede=:idSede,idEstablecimiento=:idEstablecimiento,idLocalidad=:idLocalidad,idUPZ=:idUPZ,nombre=:nombre,codigoDane=:codigoDane,consecutivo=:consecutivo,orden=:orden,sector=:sector,zona=:zona,direccion=:direccion,barrio=:barrio,telefono=:telefono,correoElectronico=:correoElectronico,web=:web,rector=:rector,tipoDocumentoRector=:tipoDocumentoRector,numeroDocumentoRector=:numeroDocumentoRector,cargo=:cargo,codigoPlantaFisica=:codigoPlantaFisica,concesion=:concesion";
				$stmtRegistro = $con->prepare($Sentencia);
				$idSede =htmlspecialchars(strip_tags(idSede));
				$idEstablecimiento =htmlspecialchars(strip_tags($idEstablecimiento));
				$idLocalidad =htmlspecialchars(strip_tags($idLocalidad));
				$idUPZ =htmlspecialchars(strip_tags($idUPZ));
				$nombre =htmlspecialchars(strip_tags($nombre));
				$codigoPlantaFisica =htmlspecialchars(strip_tags($codigoPlantaFisica));
				$codigoDane =htmlspecialchars(strip_tags($codigoDane));
				$consecutivo =htmlspecialchars(strip_tags($consecutivo));
				$orden =htmlspecialchars(strip_tags($orden));
				$sector =htmlspecialchars(strip_tags($sector));
				$zona =htmlspecialchars(strip_tags($zona));
				$direccion =htmlspecialchars(strip_tags($direccion));
				$barrio =htmlspecialchars(strip_tags($barrio));
				$telefono =htmlspecialchars(strip_tags($telefono));
				$correoElectronico =htmlspecialchars(strip_tags($correoElectronico));
				$web =htmlspecialchars(strip_tags($web));
				$rector =htmlspecialchars(strip_tags($rector));
				$tipoDocumentoRector =htmlspecialchars(strip_tags($tipoDocumentoRector));
				$numeroDocumentoRector =htmlspecialchars(strip_tags($numeroDocumentoRector));
				$cargo =htmlspecialchars(strip_tags($cargo));
				$codigoPlantaFisica =htmlspecialchars(strip_tags($codigoPlantaFisica));
				$concesion =htmlspecialchars(strip_tags($concesion));
				$stmtRegistro->bindParam(":idSede",$idSede);
				$stmtRegistro->bindParam(":idEstablecimiento",$idEstablecimiento);
				$stmtRegistro->bindParam(":idLocalidad",$idLocalidad);
				$stmtRegistro->bindParam(":idUPZ",$idUPZ);
				$stmtRegistro->bindParam(":nombre",$nombre);
				$stmtRegistro->bindParam(":codigoDane",$codigoDane);
				$stmtRegistro->bindParam(":consecutivo",$consecutivo);
				$stmtRegistro->bindParam(":orden",$orden);
				$stmtRegistro->bindParam(":sector",$sector);
				$stmtRegistro->bindParam(":zona",$zona);
				$stmtRegistro->bindParam(":direccion",$direccion);
				$stmtRegistro->bindParam(":barrio",$barrio);
				$stmtRegistro->bindParam(":telefono",$telefono);
				$stmtRegistro->bindParam(":correoElectronico",$correoElectronico);
				$stmtRegistro->bindParam(":web",$web);
				$stmtRegistro->bindParam(":rector",$rector);
				$stmtRegistro->bindParam(":tipoDocumentoRector",$tipoDocumentoRector);
				$stmtRegistro->bindParam(":numeroDocumentoRector",$numeroDocumentoRector);
				$stmtRegistro->bindParam(":cargo",$cargo);
				$stmtRegistro->bindParam(":codigoPlantaFisica",$codigoPlantaFisica);
				$stmtRegistro->bindParam(":concesion",$concesion);
				if($stmtRegistro->execute())
				{
					echo "1";
				}
				else
				{
					echo "2";
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function ModificarSede($idSede,$nombre,$codigoDane,$consecutivo,$orden,$sector,$zona,$direccion,$barrio,$telefono,$correoElectronico,$web,$rector,$tipoDocumentoRector,$numeroDocumentoRector,$cargo,$codigoPlantaFisica,$concesion)
		{
			try
			{
				include ("config.php");
				$Sentencia = "UPDATE sede SET nombre=:nombre,codigoDane=:codigoDane,consecutivo=:consecutivo,orden=:orden,sector=:sector,zona=:zona,direccion=:direccion,barrio=:barrio,telefono=:telefono,correoElectronico=:correoElectronico,web=:web,rector=:rector,tipoDocumentoRector=:tipoDocumentoRector,numeroDocumentoRector=:numeroDocumentoRector,cargo=:cargo,codigoPlantaFisica=:codigoPlantaFisica,concesion=:concesion Where idSede=:idSede";
				$stmtRegistro = $con->prepare($Sentencia);
				$nombre =htmlspecialchars(strip_tags($nombre));
				$codigoDane =htmlspecialchars(strip_tags($codigoDane));
				$consecutivo =htmlspecialchars(strip_tags($consecutivo));
				$orden =htmlspecialchars(strip_tags($orden));
				$sector =htmlspecialchars(strip_tags($sector));
				$zona =htmlspecialchars(strip_tags($zona));
				$direccion =htmlspecialchars(strip_tags($direccion));
				$barrio =htmlspecialchars(strip_tags($barrio));
				$telefono =htmlspecialchars(strip_tags($telefono));
				$correoElectronico =htmlspecialchars(strip_tags($correoElectronico));
				$web =htmlspecialchars(strip_tags($web));
				$rector =htmlspecialchars(strip_tags($rector));
				$tipoDocumentoRector =htmlspecialchars(strip_tags($tipoDocumentoRector));
				$numeroDocumentoRector =htmlspecialchars(strip_tags($numeroDocumentoRector));
				$cargo =htmlspecialchars(strip_tags($cargo));
				$codigoPlantaFisica =htmlspecialchars(strip_tags($codigoPlantaFisica));
				$concesion =htmlspecialchars(strip_tags($concesion));
				$stmtRegistro->bindParam(":idSede",$idSede);
				$stmtRegistro->bindParam(":nombre",$nombre);
				$stmtRegistro->bindParam(":codigoDane",$codigoDane);
				$stmtRegistro->bindParam(":consecutivo",$consecutivo);
				$stmtRegistro->bindParam(":orden",$orden);
				$stmtRegistro->bindParam(":sector",$sector);
				$stmtRegistro->bindParam(":zona",$zona);
				$stmtRegistro->bindParam(":direccion",$direccion);
				$stmtRegistro->bindParam(":barrio",$barrio);
				$stmtRegistro->bindParam(":telefono",$telefono);
				$stmtRegistro->bindParam(":correoElectronico",$correoElectronico);
				$stmtRegistro->bindParam(":web",$web);
				$stmtRegistro->bindParam(":rector",$rector);
				$stmtRegistro->bindParam(":tipoDocumentoRector",$tipoDocumentoRector);
				$stmtRegistro->bindParam(":numeroDocumentoRector",$numeroDocumentoRector);
				$stmtRegistro->bindParam(":cargo",$cargo);
				$stmtRegistro->bindParam(":codigoPlantaFisica",$codigoPlantaFisica);
				$stmtRegistro->bindParam(":concesion",$concesion);
				if($stmtRegistro->execute())
				{
					echo "3";
				}
				else
				{
					echo "2";
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function EliminarSede($id)
		{
			try
			{
				include ("config.php");
				$Sentencia="DELETE FROM sede Where idSede=?";
				$stmtRegistro = $con->prepare($Sentencia);
				$stmtRegistro->bindParam(1, $id);
				if($stmtRegistro->execute())
				{
					echo "1";
				}
				else
				{
					echo "2";
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function ConsultarSede($id)
		{
			try
			{
				include ("config.php");
				$Sentencia="SELECT idSede,idEstablecimiento,idLocalidad,idUPZ,nombre,codigoDane,consecutivo,orden,sector,zona,direccion,barrio,telefono,correoElectronico,web,rector,tipoDocumentoRector,numeroDocumentoRector,cargo,codigoPlantaFisica,concesion FROM sede Where idSede=?";
				$stmtRegistro = $con->prepare($Sentencia);
				$stmtRegistro->bindParam(1, $id);
				$stmtRegistro->execute();
				$validar = 1;
				if($validar>0)
				{
					$rowRegistro = $stmtRegistro->fetch(PDO::FETCH_ASSOC);
					extract($rowRegistro);
					$arr= array(
						"idSede" =>utf8_encode($idSede),
						"idEstablecimiento" =>utf8_encode($idEstablecimiento),
						"idLocalidad" =>utf8_encode($idLocalidad),
						"idUPZ" =>utf8_encode($idUPZ),
						"nombre" =>utf8_encode($nombre),
						"codigoDane" =>utf8_encode($codigoDane),
						"consecutivo" =>utf8_encode($consecutivo),
						"orden" =>utf8_encode($orden),
						"sector" =>utf8_encode($sector),
						"zona" =>utf8_encode($zona),
						"direccion" =>utf8_encode($direccion),
						"barrio" =>utf8_encode($barrio),
						"telefono" =>utf8_encode($telefono),
						"correoElectronico" =>utf8_encode($correoElectronico),
						"web" =>utf8_encode($web),
						"rector" =>utf8_encode($rector),
						"tipoDocumentoRector" =>utf8_encode($tipoDocumentoRector),
						"numeroDocumentoRector" =>utf8_encode($numeroDocumentoRector),
						"cargo" =>utf8_encode($cargo),
						"codigoPlantaFisica" =>utf8_encode($codigoPlantaFisica),
						"concesion" =>utf8_encode($concesion),
					);
					//return $arr;
					echo '{"idSede":"'.$arr['idSede'].'",';
					echo '"idEstablecimiento":"'.$arr['idEstablecimiento'].'",';
					echo '"idLocalidad":"'.$arr['idLocalidad'].'",';
					echo '"idUPZ":"'.$arr['idUPZ'].'",';
					echo '"nombre":"'.$arr['nombre'].'",';
					echo '"codigoDane":"'.$arr['codigoDane'].'",';
					echo '"consecutivo":"'.$arr['consecutivo'].'",';
					echo '"orden":"'.$arr['orden'].'",';
					echo '"sector":"'.$arr['sector'].'",';
					echo '"zona":"'.$arr['zona'].'",';
					echo '"direccion":"'.$arr['direccion'].'",';
					echo '"barrio":"'.$arr['barrio'].'",';
					echo '"telefono":"'.$arr['telefono'].'",';
					echo '"correoElectronico":"'.$arr['correoElectronico'].'",';
					echo '"web":"'.$arr['web'].'",';
					echo '"rector":"'.$arr['rector'].'",';
					echo '"tipoDocumentoRector":"'.$arr['tipoDocumentoRector'].'",';
					echo '"numeroDocumentoRector":"'.$arr['numeroDocumentoRector'].'",';
					echo '"cargo":"'.$arr['cargo'].'",';
					echo '"codigoPlantaFisica":"'.$arr['codigoPlantaFisica'].'",';
					echo '"concesion":"'.$arr['concesion'].'"}';
				}
				else
				{
					return 0;
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function LlenarTabla()
		{
			try
			{
				include ("config.php");
				$Sentencia="SELECT s.idSede,s.idEstablecimiento,s.idLocalidad,s.idUPZ,s.nombre,s.codigoDane,s.consecutivo,s.orden,s.sector,s.zona,s.direccion,s.barrio,s.telefono,s.correoElectronico,s.web,s.rector,s.tipoDocumentoRector,s.numeroDocumentoRector,s.cargo,s.codigoPlantaFisica,s.concesion,e.nombre AS Establecimiento,l.nombreLocalidad AS Localidad FROM sede s INNER JOIN establecimiento e ON s.idEstablecimiento = e.idEstablecimiento INNER JOIN localidad l ON s.idLocalidad = l.idLocalidad";
				$stmtRegistro = $con->prepare($Sentencia);
				$stmtRegistro->execute();
				$validar = 1;
				if($validar>0)
				{
					while ($rowRegistro = $stmtRegistro->fetch(PDO::FETCH_ASSOC))
					{
						extract($rowRegistro);
						$arr[]= array(
						"idSede" =>utf8_encode($idSede),
						"idEstablecimiento" =>utf8_encode($idEstablecimiento),
						"idLocalidad" =>utf8_encode($idLocalidad),
						"Establecimiento" =>utf8_encode($Establecimiento),
						"Localidad" =>utf8_encode($Localidad),
						"UPZ" =>utf8_encode($UPZ),
						"nombre" =>utf8_encode($nombre),
						"codigoDane" =>utf8_encode($codigoDane),
						"consecutivo" =>utf8_encode($consecutivo),
						"orden" =>utf8_encode($orden),
						"sector" =>utf8_encode($sector),
						"zona" =>utf8_encode($zona),
						"telefono" =>utf8_encode($telefono),
						"web" =>utf8_encode($web),
						"rector" =>utf8_encode($rector),
						"tipoDocumentoRector" =>utf8_encode($tipoDocumentoRector),
						"numeroDocumentoRector" =>utf8_encode($numeroDocumentoRector),
						"cargo" =>utf8_encode($cargo),
						"codigoPlantaFisica" =>utf8_encode($codigoPlantaFisica),
						"concesion" =>utf8_encode($concesion),
						);
					}
					//return $arr;
					$val = 1;
					$resultado = count($arr);
					echo '[';
					foreach ($arr as $valor) {
    					echo '{"idSede":"'.$valor['idSede'].'",';
						echo '"idEstablecimiento":"'.$valor['idEstablecimiento'].'",';
						echo '"idLocalidad":"'.$valor['idLocalidad'].'",';
						echo '"Establecimiento":"'.$valor['Establecimiento'].'",';
						echo '"Localidad":"'.$valor['Localidad'].'",';
						echo '"UPZ":"'.$valor['UPZ'].'",';
						echo '"nombre":"'.$valor['nombre'].'",';
						echo '"codigoDane":"'.$valor['codigoDane'].'",';
						echo '"consecutivo":"'.$valor['consecutivo'].'",';
						echo '"orden":"'.$valor['orden'].'",';
						echo '"sector":"'.$valor['sector'].'",';
						echo '"zona":"'.$valor['zona'].'",';
						echo '"direccion":"'.$valor['direccion'].'",';
						echo '"barrio":"'.$valor['barrio'].'",';
						echo '"telefono":"'.$valor['telefono'].'",';
						echo '"correoElectronico":"'.$valor['correoElectronico'].'",';
						echo '"web":"'.$valor['web'].'",';
						echo '"rector":"'.$valor['rector'].'",';
						echo '"tipoDocumentoRector":"'.$valor['tipoDocumentoRector'].'",';
						echo '"numeroDocumentoRector":"'.$valor['numeroDocumentoRector'].'",';
						echo '"cargo":"'.$valor['cargo'].'",';
						echo '"codigoPlantaFisica":"'.$valor['codigoPlantaFisica'].'",';
						echo '"concesion":"'.$valor['concesion'].'"}';
						if($resultado > $val)
						{
							echo ',';
						}
						$val = $val + 1;
					}
					echo ']';
				}
				else
				{
					return 0;
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function ListarEstablecimientos()
		{
			try
			{
				include ("config.php");
				$Sentencia="SELECT idEstablecimiento,nombre from establecimiento";
				$stmtRegistro = $con->prepare($Sentencia);
				$stmtRegistro->execute();
				$validar = 1;
				if($validar>0)
				{
					while ($rowRegistro = $stmtRegistro->fetch(PDO::FETCH_ASSOC))
					{
						extract($rowRegistro);
						$arr[]= array(
						"idEstablecimiento" =>utf8_encode($idEstablecimiento),
						"nombre" =>utf8_encode($nombre),
						);
					}
					//return $arr;
					$val = 1;
					$resultado = count($arr);
					echo '[';
					foreach ($arr as $valor) {
    					echo '{"idEstablecimiento":"'.$valor['idEstablecimiento'].'",';
						echo '"nombre":"'.$valor['nombre'].'"}';
						if($resultado > $val)
						{
							echo ',';
						}
						$val = $val + 1;
					}
					echo ']';
				}
				else
				{
					return 0;
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function ListarLocalidades()
		{
			try
			{
				include ("config.php");
				$Sentencia="SELECT idLocalidad,nombreLocalidad from localidad";
				$stmtRegistro = $con->prepare($Sentencia);
				$stmtRegistro->execute();
				$validar = 1;
				if($validar>0)
				{
					while ($rowRegistro = $stmtRegistro->fetch(PDO::FETCH_ASSOC))
					{
						extract($rowRegistro);
						$arr[]= array(
						"idLocalidad" =>utf8_encode($idLocalidad),
						"nombre" =>utf8_encode($nombreLocalidad),
						);
					}
					//return $arr;
					$val = 1;
					$resultado = count($arr);
					echo '[';
					foreach ($arr as $valor) {
    					echo '{"idLocalidad":"'.$valor['idLocalidad'].'",';
						echo '"nombre":"'.$valor['nombre'].'"}';
						if($resultado > $val)
						{
							echo ',';
						}
						$val = $val + 1;
					}
					echo ']';
				}
				else
				{
					return 0;
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function ListarUPZ()
		{
			try
			{
				include ("config.php");
				$Sentencia="SELECT idUPZ,nombreUPZ from upz";
				$stmtRegistro = $con->prepare($Sentencia);
				$stmtRegistro->execute();
				$validar = 1;
				if($validar>0)
				{
					while ($rowRegistro = $stmtRegistro->fetch(PDO::FETCH_ASSOC))
					{
						extract($rowRegistro);
						$arr[]= array(
						"idUPZ" =>utf8_encode($idUPZ),
						"nombre" =>utf8_encode($nombreUPZ),
						);
					}
					//return $arr;
					$val = 1;
					$resultado = count($arr);
					echo '[';
					foreach ($arr as $valor) {
    					echo '{"idUPZ":"'.$valor['idUPZ'].'",';
						echo '"nombre":"'.$valor['nombre'].'"}';
						if($resultado > $val)
						{
							echo ',';
						}
						$val = $val + 1;
					}
					echo ']';
				}
				else
				{
					return 0;
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
	}
?>
