<?php
	class UPZ
	{
		function InsertarUPZ($numeroUPZ,$nombreUPZ)
		{
			try
			{
				include ("config.php");
				$Sentencia = "INSERT INTO upz SET numeroUPZ=:numeroUPZ,nombreUPZ=:nombreUPZ";
				$stmtRegistro = $con->prepare($Sentencia);
				$numeroUPZ =htmlspecialchars(strip_tags($numeroUPZ));
				$nombreUPZ =htmlspecialchars(strip_tags($nombreUPZ));
				$stmtRegistro->bindParam(":numeroUPZ",$numeroUPZ);
				$stmtRegistro->bindParam(":nombreUPZ",$nombreUPZ);
				if($stmtRegistro->execute())
				{
					echo "1";
				}
				else
				{
					echo "2";
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function ModificarUPZ($idUPZ,$numeroUPZ,$nombreUPZ)
		{
			try
			{
				include ("config.php");
				$Sentencia = "UPDATE upz SET numeroUPZ=:numeroUPZ,nombreUPZ=:nombreUPZ Where idUPZ=:idUPZ";
				$stmtRegistro = $con->prepare($Sentencia);
				$numeroUPZ =htmlspecialchars(strip_tags($numeroUPZ));
				$nombreUPZ =htmlspecialchars(strip_tags($nombreUPZ));
				$stmtRegistro->bindParam(":idUPZ",$idUPZ);
				$stmtRegistro->bindParam(":numeroUPZ",$numeroUPZ);
				$stmtRegistro->bindParam(":nombreUPZ",$nombreUPZ);
				if($stmtRegistro->execute())
				{
					echo "3";
				}
				else
				{
					echo "2";
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function EliminarUPZ($id)
		{
			try
			{
				include ("config.php");
				$Sentencia="DELETE FROM upz Where idUPZ=?";
				$stmtRegistro = $con->prepare($Sentencia);
				$stmtRegistro->bindParam(1, $id);
				if($stmtRegistro->execute())
				{
					echo "1";
				}
				else
				{
					echo "2";
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function ConsultarUPZ($id)
		{
			try
			{
				include ("config.php");
				$Sentencia="SELECT idUPZ,numeroUPZ,nombreUPZ FROM upz Where idUPZ=?";
				$stmtRegistro = $con->prepare($Sentencia);
				$stmtRegistro->bindParam(1, $id);
				$stmtRegistro->execute();
				$validar = 1;
				if($validar>0)
				{
					$rowRegistro = $stmtRegistro->fetch(PDO::FETCH_ASSOC);
					extract($rowRegistro);
					$arr= array(
						"idUPZ" =>utf8_encode($idUPZ),
						"numeroUPZ" =>utf8_encode($numeroUPZ),
						"nombreUPZ" =>utf8_encode($nombreUPZ),
					);
					//return $arr;
					echo '{"idUPZ":"'.$arr['idUPZ'].'",';
					echo '"numeroUPZ":"'.$arr['numeroUPZ'].'",';
					echo '"nombreUPZ":"'.$arr['nombreUPZ'].'"}';
				}
				else
				{
					return 0;
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
		function LlenarTabla()
		{
			try
			{
				include ("config.php");
				$Sentencia="SELECT idUPZ,numeroUPZ,nombreUPZ FROM upz";
				$stmtRegistro = $con->prepare($Sentencia);
				$stmtRegistro->execute();
				$validar = 1;
				if($validar>0)
				{
					while ($rowRegistro = $stmtRegistro->fetch(PDO::FETCH_ASSOC))
					{
						extract($rowRegistro);
						$arr[]= array(
						"idUPZ" =>utf8_encode($idUPZ),
						"numeroUPZ" =>utf8_encode($numeroUPZ),
						"nombreUPZ" =>utf8_encode($nombreUPZ),
						);
					}
					//return $arr;
					$val = 1;
					$resultado = count($arr);
					echo '[';
					foreach ($arr as $valor) {
    					echo '{"idUPZ":"'.$valor['idUPZ'].'",';
						echo '"numeroUPZ":"'.$valor['numeroUPZ'].'",';
						echo '"nombreUPZ":"'.$valor['nombreUPZ'].'"}';
						if($resultado > $val)
						{
							echo ',';
						}
						$val = $val + 1;
					}
					echo ']';
				}
				else
				{
					return 0;
				}
			}
			catch(PDOException $exception)
			{
				echo "Error: " . $exception->getMessage();
			}
		}
	}
?>
