<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<title>Fichas de Proyectos</title>
	

    <!-- Bootstrap core CSS -->
    <link href="../cms/css/bootstrap.css" rel="stylesheet">

    <!-- Add custom CSS here -->
    
    <link rel="stylesheet" href="font-awesome/css/font-awesome.min.css">
    <!-- Page Specific CSS -->
    <link rel="stylesheet" href="http://cdn.oesmith.co.uk/morris-0.4.3.min.css">
    
	<link href="../cms/css/style.css" rel="stylesheet" media="screen" />
	
  </head>

  <body>

    <div id="wrapper">

		<!-- Sidebar -->
		<nav class="navbar navbar-inverse navbar-fixed-top" role="navigation">
			<!-- Brand and toggle get grouped for better mobile display -->
			<div class="navbar-header">
				<button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-ex1-collapse">
					<span class="sr-only">Toggle navigation</span>
					<span class="icon-bar"></span>
					<span class="icon-bar"></span>
					<span class="icon-bar"></span>
				</button>
				<a class="navbar-brand" href="../cms/index.php"><img src="../cms/Img/logo.png" width="90px" />SED - SIIC</a>
			</div>
		<!-- Collect the nav links, forms, and other content for toggling -->
		</nav>
		<div id="page-wrapper">
			<div class="container">
				<div class="margin-bottom-1em overflow-hidden">
					<br>
					<div id="loader-image" class="loading-gif"></div>
				</div>
				<div class="page-header">
					<h1 id="page-title"></h1>
				</div>
				<br>
				<div id="message_alerta" style="display:none"></div>
				<div id="page-content"></div>
			</div>
			<script src="../cms/js/jquery-1.10.2.js"></script>
			<script src="../cms/js/bootstrap.js"></script>
			<link rel="stylesheet" type="text/css" href="../cms/css/jquery.dataTables.css">
			<script type="text/javascript" language="javascript" src="../cms/js/jquery.dataTables.js"></script>
			
			
			<script type="text/javascript">
				$(document).ready(function(){
					Listar();
					$("#loader-image").show();
					 $('[data-toggle="tooltip"]').tooltip(); 
				});
				function changePageTitle(page_title)
				{
					$("#page-title").text(page_title);
					document.title=page_title;
				}
				function Listar()
				{
					changePageTitle("Fichas de Proyectos");
					$("#message_alerta").css("display","none");
					$("#page-content").fadeOut("slow", function()
					{
						tabla ="<table class='table table-striped' id='dt_lista_usuarios'>";
						tabla=tabla +"<thead><tr>";
						tabla=tabla +"<th>Nombre Proyecto</th>";
						tabla=tabla +"<th>Direccion</th>";
						tabla=tabla +"<th>Estado</th>";
						tabla=tabla +"<th>Ver Ficha</th>";
						tabla=tabla +"</tr></thead>";
						tabla=tabla +"<tbody></tbody>";
						tabla=tabla +"</table>";
						$("#loader-image").hide();
						$("#page-content").fadeIn("slow");
						$("#page-content").empty();
						$("#page-content").append(tabla);
						$("#dt_lista_usuarios").DataTable(
						{
							"language":
							{
								"emptyTable":"No hay información disponible",
								"info":"Listado _START_ a _END_ de _TOTAL_ Registros",
								"infoEmpty":"Listado 0 a 0 de 0 Registros",
								"infoFiltered":"(filtrado de _MAX_ registros)",
								"infoPostFix":"",
								"thousands":",",
								"lengthMenu":"Mostrar _MENU_ Registros",
								"loadingRecords": "Cargando...",
								"processing":     "Procesando...",
								"search":         "Buscar:",
								"zeroRecords":    "No se encontraron registros",
								"paginate": {
									"first":      "Primera",
									"last":       "Ultima",
									"next":       "Siguiente",
									"previous":   "Anterior"
								}
							}
						});
						var tabla=$("#dt_lista_usuarios").DataTable();
						$.post("../cms/Proyecto/Actualizar.php",{accion:"4"},
							function(data)
							{
								if(data!="0")
								{
									for(var i=0;i<data.length;i++)
									{
										tabla.row.add( 
										[
											data[i].nombreProyecto,
											data[i].direccion,
											data[i].idEstado,
											"<form method='post' action='AgregarTabla.php' target='_blank'><input type='hidden' name='id' value='"+data[i].idSede+"' /><button class='btn btn-info btn-xs'><span class='glyphicon glyphicon-info'></span>Ver Ficha</button></form>",											
										]).draw(false);
									}
								}
								else
								{
									if (data=="0")
									{
										message(3,"No se encontraron Registros.");
									}
									else
									{
										message(4,data);
									}
								}
							},"json");
					});
				}
				function message(tipo,mensaje)
				{
					switch (tipo)
					{
						case(1):
							alerta='<div id="Message" class="alert alert-success alert-dismissable"><button type="button" class="close" data-dismiss="alert">&times;</button>'+mensaje+'</div>';
							break;
						case(2):
							alerta='<div id="Message" class="alert alert-info alert-dismissable"><button type="button" class="close" data-dismiss="alert">&times;</button>'+mensaje+'</div>';
							break;
						case(3):
							alerta='<div id="Message" class="alert alert-warning alert-dismissable"><button type="button" class="close" data-dismiss="alert">&times;</button>'+mensaje+'</div>';
							break;
						case(4):
							alerta='<div id="Message" class="alert alert-warning alert-dismissable"><button type="button" class="close" data-dismiss="alert">&times;</button>'+mensaje+'</div>';
							break;
					}
					$("#message_alerta").html(alerta);
					$("#message_alerta").fadeIn("slow");
						setTimeout(function(){
							$("#message_alerta").fadeOut("slow");
						},5000);
				}
			</script>
		</div>
</div>


  </body>

  </html>
