CREATE TABLE categoria (
  idCategoria NUMBER GENERATED BY DEFAULT AS IDENTITY primary key,
  nombre varchar(128) NOT NULL
) ;

CREATE TABLE contratoacta (
  idContratoActa NUMBER GENERATED BY DEFAULT AS IDENTITY primary key,
  objeto long,
  valorTotalFacturado varchar(21) DEFAULT NULL,
  valorAmortizado varchar(21) DEFAULT NULL,
  valorRetencion varchar(21) DEFAULT NULL,
  valorAjustePeso varchar(21) DEFAULT NULL,
  valorPagadoAjustePeso varchar(21) DEFAULT NULL,
  periodoActa varchar(128) DEFAULT NULL,
  fechaRadicacion date DEFAULT NULL,
  numeroRadicacion varchar(128) DEFAULT NULL,
  numeroDevolucion varchar(128) DEFAULT NULL,
  responsableRevision varchar(128) DEFAULT NULL,
  fechaRevision date DEFAULT NULL,
  presentaCertificacion varchar(128) DEFAULT NULL,
  pagoSalud varchar(128) DEFAULT NULL,
  pagoPension varchar(128) DEFAULT NULL,
  mesPago varchar(128) DEFAULT NULL,
  idContrato number(10) NOT NULL
) ;

CREATE TABLE contratodatosbasicos (
  idcontrato NUMBER GENERATED BY DEFAULT AS IDENTITY primary key,
  numeroSOC varchar(128) NOT NULL,
  licitacion varchar(128) DEFAULT NULL,
  clase varchar(5) NOT NULL,
  numeroContrato varchar(10) NOT NULL,
  contratista varchar(128) NOT NULL,
  telefonoC varchar(50) DEFAULT NULL,
  direccionC varchar(128) DEFAULT NULL,
  numeroIdentificacionC varchar(50) NOT NULL,
  correoElectronicoC varchar(80) DEFAULT NULL,
  representanteLegal varchar(128) NOT NULL,
  objeto long NOT NULL,
  estado varchar(50) NOT NULL,
  rubro varchar(128) NOT NULL,
  fechaInicio date NULL,
  fechaTerminacion date  NULL,
  interventoria varchar(128) DEFAULT NULL,
  supervisor varchar(128) DEFAULT NULL,
  valorContratoInicial varchar(21) NOT NULL,
  valorTotalContrato varchar(21) NOT NULL,
  porcentajeEjecutado varchar(7) DEFAULT NULL,
  fechaContrato date NULL,
  cuentaConjunta varchar(2) DEFAULT NULL,
  numeroPoliza varchar(128) DEFAULT NULL,
  aseguradora varchar(128) DEFAULT NULL,
  fechaAprobacionPoliza date DEFAULT NULL,
  fechaRadicacion date DEFAULT NULL,
  numeroCDP varchar(10) DEFAULT NULL,
  fechaCDP date DEFAULT NULL,
  numeroRP varchar(10) DEFAULT NULL,
  fechaRP date DEFAULT NULL,
  idSede number(10) DEFAULT NULL
) ;

CREATE TABLE contratotiempos (
  idContratoTiempos NUMBER GENERATED BY DEFAULT AS IDENTITY primary key,
  plazoInicial number(10) DEFAULT NULL,
  plazoAdicional number(10) DEFAULT NULL,
  tiempoSuspendido number(10) DEFAULT NULL,
  idContrato number(10) NOT NULL
) ;

CREATE TABLE contratovalores (
  idContratoValores NUMBER GENERATED BY DEFAULT AS IDENTITY primary key,
  valorAdiciones varchar(21) DEFAULT NULL,
  valorReconocimientos varchar(21) DEFAULT NULL,
  valorAnticipo varchar(21) DEFAULT NULL,
  valorTotalPagadoActas varchar(21) DEFAULT NULL,
  valorAmorizado varchar(21) DEFAULT NULL,
  valorRetencion varchar(21) DEFAULT NULL,
  valorTotalPagado varchar(21) DEFAULT NULL,
  saldoPorPagar varchar(21) DEFAULT NULL,
  idContrato number(10) NOT NULL
) ;

CREATE TABLE establecimiento (
  idEstablecimiento NUMBER GENERATED BY DEFAULT AS IDENTITY primary key,
  nombre varchar(128) NOT NULL,
  numeroIdentificacion varchar(50) NULL,
  codigoDane varchar(50)  NULL,
  clase varchar(50)  NULL,
  naturalezaJuridica varchar(50)  NULL,
  estado varchar(50)  NULL
) ;

CREATE TABLE estado (
  idEstado  NUMBER GENERATED BY DEFAULT AS IDENTITY primary key,
  nombre varchar(128) NOT NULL
) ;

CREATE TABLE estadobh (
  idEstado NUMBER GENERATED BY DEFAULT AS IDENTITY primary key,
  nombre varchar(128) NOT NULL
) ;


CREATE TABLE etapaproyecto (
  idEtapa NUMBER GENERATED BY DEFAULT AS IDENTITY primary key,
  nombre varchar(128) NOT NULL
) ;

CREATE TABLE financiacion (
  idFinanciacion NUMBER GENERATED BY DEFAULT AS IDENTITY primary key,
  nombre varchar(128) NOT NULL
) ;


CREATE TABLE gestionsuelodatosadicionales (
  idGestionSueloDatosAdicionales NUMBER GENERATED BY DEFAULT AS IDENTITY primary key,
  eaab varchar(2) DEFAULT NULL,
  remocion varchar(2) DEFAULT NULL,
  vias varchar(2) DEFAULT NULL,
  energia varchar(2) DEFAULT NULL,
  otros varchar(2) DEFAULT NULL,
  nombreLocal varchar(256) DEFAULT NULL,
  valorizacionLocal varchar(30) DEFAULT NULL,
  fechaValorizacionLocal date DEFAULT NULL,
  nombreGeneral varchar(128) DEFAULT NULL,
  valorizacionGeneral varchar(30) DEFAULT NULL,
  fechaValorizacionGeneral date DEFAULT NULL,
  observaciones long,
  fechaActualizacion date DEFAULT NULL,
  idGestionSuelo number(10) NOT NULL
) ;

CREATE TABLE gestionsuelodatosbasicos (
  idGestionSuelo NUMBER GENERATED BY DEFAULT AS IDENTITY primary key,
  areaLote varchar(10)  NULL,
  numeroPredios number(3)  NULL,
  suceptibleAmpliacion varchar(2) NULL,
  usoPredio varchar(600) NULL,
  reconocimiento varchar(128)  NULL,
  delimitacionAreas varchar(128)  NULL,
  estadoContruccion varchar(128)  NULL,
  propiedad varchar(20)  NULL,
  certificado varchar(2)  NULL,
  idSede number(10) NOT NULL,
  planoUrbanistico varchar(600) DEFAULT NULL,
  resolucionUrbanistica varchar(128) DEFAULT NULL,
  barrioUrbanistico varchar(128)  NULL,
  pendienteEntrega varchar(2) DEFAULT NULL,
  eaab varchar(2) DEFAULT NULL,
  remocion varchar(2) DEFAULT NULL,
  vias varchar(2) DEFAULT NULL,
  energia varchar(2) DEFAULT NULL,
  otros varchar(2) DEFAULT NULL,
  nombreLocal varchar(500) DEFAULT NULL,
  valorizacionLocal varchar(30) DEFAULT NULL,
  fechaValorizacionLocal date DEFAULT NULL,
  nombreGeneral varchar(128) DEFAULT NULL,
  valorizacionGeneral varchar(30) DEFAULT NULL,
  fechaValorizacionGeneral date DEFAULT NULL,
  observaciones long,
  usuarioModifica number(11) DEFAULT NULL,
  fechaModifica date DEFAULT NULL,
  fechaActualizacion date DEFAULT NULL
) ;

CREATE TABLE gestionsuelodocumentacion (
  idGestionSueloDocumentacion NUMBER GENERATED BY DEFAULT AS IDENTITY primary key,
  fechaEntregaDJ varchar(128) DEFAULT NULL,
  codigoRupi varchar(500) DEFAULT NULL,
  escritura varchar(256) DEFAULT NULL,
  fechaEscritura varchar(256) DEFAULT NULL,
  notaria varchar(256) DEFAULT NULL,
  actaProcuraduria varchar(256) DEFAULT NULL,
  fechaActaProcuraduria varchar(256) DEFAULT NULL,
  actaDadep varchar(256) DEFAULT NULL,
  fechaActaDadep varchar(256) DEFAULT NULL,
  matriculaInmobiliaria varchar(500) DEFAULT NULL,
  cedulaCatastral varchar(128) DEFAULT NULL,
  codigoChip varchar(128) DEFAULT NULL,
  anoAvaluo number(20) DEFAULT NULL,
  planoUrbanistico varchar(500) DEFAULT NULL,
  resolucionUrbanistica varchar(256) DEFAULT NULL,
  barrioUrbanistico varchar(256) NULL,
  pendienteEntrega varchar(2) DEFAULT NULL,
  idGestionSuelo number(10) NOT NULL
) ;

CREATE TABLE gestionsuelopredio (
  idGestionPredio NUMBER GENERATED BY DEFAULT AS IDENTITY primary key,
  direccion varchar(256) NOT NULL,
  usoPredio varchar(128) NOT NULL,
  fechaEntregaDJ varchar(128) DEFAULT NULL,
  codigoRupi varchar(128) DEFAULT NULL,
  escritura varchar(100) DEFAULT NULL,
  fechaEscritura varchar(128) DEFAULT NULL,
  notaria varchar(128) DEFAULT NULL,
  actaProcuraduria varchar(128) DEFAULT NULL,
  fechaActaProcuraduria varchar(128) DEFAULT NULL,
  actaDadep varchar(128) DEFAULT NULL,
  fechaActaDadep varchar(128) DEFAULT NULL,
  matriculaInmobiliaria varchar(500) DEFAULT NULL,
  cedulaCatastral varchar(128) DEFAULT NULL,
  codigoSector varchar(128) DEFAULT NULL,
  codigoChip varchar(128) DEFAULT NULL,
  valorAvaluo varchar(30) DEFAULT NULL,
  anoAvaluo number(4) DEFAULT NULL,
  observaciones varchar(256) NOT NULL,
  usuarioModifica number(11) DEFAULT NULL,
  fechaModifica date DEFAULT NULL,
  idGestionSuelo number(10) NOT NULL
) ;


CREATE TABLE localidad (
  idLocalidad NUMBER GENERATED BY DEFAULT AS IDENTITY primary key,
  numeroLocalidad varchar(10) NOT NULL,
  nombreLocalidad varchar(128) NOT NULL
) ;


CREATE TABLE meta (
  idMeta NUMBER GENERATED BY DEFAULT AS IDENTITY primary key,
  nombre varchar(128) NOT NULL
) ;


CREATE TABLE proyecto (
  idproyecto NUMBER GENERATED BY DEFAULT AS IDENTITY primary key,
  nombreProyecto varchar(255) NOT NULL,
  direccion varchar(255) DEFAULT NULL,
  anoEntrega varchar(4) DEFAULT NULL,
  etapa varchar(128) DEFAULT NULL,
  avanceEtapa varchar(4) DEFAULT NULL,
  areaIntervenir varchar(20) DEFAULT NULL,
  aulasPIA number(10) DEFAULT NULL,
  aulasPIB number(10) DEFAULT NULL,
  aulasP number(10) DEFAULT NULL,
  aulasS number(10) DEFAULT NULL,
  aulasM number(10) DEFAULT NULL,
  capacidadAlumnos number(10) DEFAULT NULL,
  valorOI varchar(30) DEFAULT NULL,
  jardinPI varchar(2) DEFAULT NULL,
  supervisor varchar(255) DEFAULT NULL,
  imagen varchar(255) DEFAULT NULL,
  reportadosEje varchar(2) DEFAULT NULL,
  estadoBH varchar(128) DEFAULT NULL,
  avanceBH varchar(4) DEFAULT NULL,
  idSede number(10) NOT NULL,
  idMeta number(10) NOT NULL,
  idFinanciacion number(10) NOT NULL,
  idCategoria number(10) NOT NULL,
  idEstado number(10) NOT NULL,
  observaciones varchar(255) DEFAULT NULL,
  fechaModifica date DEFAULT NULL,
  usuarioModifica number(11) DEFAULT NULL,
  inactivar number(11) NOT NULL
) ;


CREATE TABLE proyectoavance (
  idProyectoAvance NUMBER GENERATED BY DEFAULT AS IDENTITY primary key,
  idProyecto number(10) NOT NULL,
  nombreProyecto varchar(255) NOT NULL,
  direccion varchar(255) DEFAULT NULL,
  anoEntrega varchar(4) DEFAULT NULL,
  etapa varchar(128) DEFAULT NULL,
  avanceEtapa varchar(4) DEFAULT NULL,
  areaIntervenir varchar(20) DEFAULT NULL,
  aulasPIA number(10) DEFAULT NULL,
  aulasPIB number(10) DEFAULT NULL,
  aulasP number(10) DEFAULT NULL,
  aulasS number(10) DEFAULT NULL,
  aulasM number(10) DEFAULT NULL,
  capacidadAlumnos number(10) DEFAULT NULL,
  valorOI varchar(30) DEFAULT NULL,
  jardinPI varchar(2) DEFAULT NULL,
  supervisor varchar(255) DEFAULT NULL,
  imagen varchar(255) DEFAULT NULL,
  reportadosEje varchar(2) DEFAULT NULL,
  estadoBH varchar(128) DEFAULT NULL,
  avanceBH varchar(4) DEFAULT NULL,
  idSede number(10) NOT NULL,
  idMeta number(10) NOT NULL,
  idFinanciacion number(10) NOT NULL,
  idCategoria number(10) NOT NULL,
  idEstado number(10) NOT NULL,
  observaciones varchar(255) DEFAULT NULL,
  tipoAvance varchar(1) NULL,
  fechaModifica date NOT NULL,
  usuarioModifica number(11) NOT NULL
) ;


CREATE TABLE proyectointerventoria (
  idProyectoInterventoria NUMBER GENERATED BY DEFAULT AS IDENTITY primary key,
  contratoInterventoria varchar(128) DEFAULT NULL,
  valorICIVA varchar(21) DEFAULT NULL,
  adicionCITVA varchar(21) DEFAULT NULL,
  valorICIVAC varchar(21) DEFAULT NULL,
  adicionCITVAC varchar(21) DEFAULT NULL,
  idProyecto number(11) NOT NULL
) ;

CREATE TABLE proyectoobra (
  idProyectoObra NUMBER GENERATED BY DEFAULT AS IDENTITY primary key,
  contratoObra varchar(128) DEFAULT NULL,
  valorICOVA varchar(21) DEFAULT NULL,
  adicionCOTVA varchar(21) DEFAULT NULL,
  valorICOVAC varchar(21) DEFAULT NULL,
  adicionCOTVAC varchar(21) DEFAULT NULL,
  adicion varchar(21) DEFAULT NULL,
  idProyecto number(11) NOT NULL
) ;

CREATE TABLE sede (
  idSede NUMBER GENERATED BY DEFAULT AS IDENTITY primary key,
  idEstablecimiento number(10) NOT NULL,
  idLocalidad number(10) NOT NULL,
  idUPZ number(10) NOT NULL,
  nombre varchar(500) NOT NULL,
  codigoDane varchar(50) NULL,
  consecutivo varchar(5)  NULL,
  orden varchar(2)  NULL,
  sector varchar(50)  NULL,
  zona varchar(128)  NULL,
  direccion varchar(500) NULL,
  barrio varchar(128) DEFAULT NULL,
  telefono varchar(50) DEFAULT NULL,
  correoElectronico varchar(80) DEFAULT NULL,
  web varchar(128) DEFAULT NULL,
  rector varchar(128)  NULL,
  tipoDocumentoRector varchar(5) NULL,
  numeroDocumentoRector varchar(50)  NULL,
  cargo varchar(30)  NULL,
  codigoPlantaFisica number(10) NOT NULL,
  concesion varchar(2) NOT NULL
) ;

CREATE TABLE tipousuario (
  idtipousuario NUMBER GENERATED BY DEFAULT AS IDENTITY primary key,
  nombre varchar(100) DEFAULT NULL
) ;

CREATE TABLE upz (
  idUPZ NUMBER GENERATED BY DEFAULT AS IDENTITY primary key,
  numeroUPZ number(10) NOT NULL,
  nombreUPZ varchar(128) NOT NULL
) ;

CREATE TABLE usuario (
  idusuario NUMBER GENERATED BY DEFAULT AS IDENTITY primary key,
  idtipousuario number(10) NOT NULL,
  nombre varchar(150) DEFAULT NULL,
  apellidos varchar(150) DEFAULT NULL,
  tipodoc varchar(5) DEFAULT NULL,
  numerodoc varchar(20) DEFAULT NULL,
  direccion varchar(200) DEFAULT NULL,
  telefono varchar(50) DEFAULT NULL,
  correo varchar(200) DEFAULT NULL
) ;

